/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.security;

import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.internal.report.ApiReporter;
import com.taobao.api.internal.util.Base64;
import com.taobao.api.internal.util.LruHashMap;
import com.taobao.api.internal.util.NamedThreadFactory;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.security.SecretContext;
import com.taobao.api.security.SecurityConstants;
import com.taobao.api.security.TopSecretGetRequest;
import com.taobao.api.security.TopSecretGetResponse;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityCore
implements SecurityConstants {
    private static final Log log = LogFactory.getLog(SecurityCore.class);
    private String randomNum;
    private static final LruHashMap<String, SecretContext> appUserSecretCache = new LruHashMap(16, 131072);
    private static final Map<String, SecretContext> appSecretCache = new ConcurrentHashMap<String, SecretContext>();
    private static ExecutorService asynUpdateSecret;
    private DefaultTaobaoClient taobaoClient;
    private static final ConcurrentHashMap<String, Object> asynQueueKey;
    private static final Object emptyValue;
    private static AtomicBoolean initThreadPoolAtomic;
    private boolean streetest;
    private static final ConcurrentHashMap<String, Map<String, Object>> allAppConfig;

    public static void shutdown() {
        if (asynUpdateSecret != null) {
            asynUpdateSecret.shutdown();
            ApiReporter.shutdown();
            initThreadPoolAtomic = new AtomicBoolean(false);
        }
    }

    public static LruHashMap<String, SecretContext> getAppUserSecretCache() {
        return appUserSecretCache;
    }

    public boolean isIndexEncrypt(String key, Long version) {
        key = version != null && version < 0L ? "previous_" + key : "current_" + key;
        Map<String, Object> appConfig = this.getAppConfig();
        return appConfig != null && "2".equals(appConfig.get(key));
    }

    public int getCompressLen() {
        String compressLen;
        Map<String, Object> appConfig = this.getAppConfig();
        if (appConfig != null && (compressLen = (String)appConfig.get("encrypt_index_compress_len")) != null) {
            return Integer.parseInt(compressLen);
        }
        return 3;
    }

    public int getSlideSize() {
        String encryptSlideSize;
        Map<String, Object> appConfig = this.getAppConfig();
        if (appConfig != null && (encryptSlideSize = (String)appConfig.get("encrypt_slide_size")) != null) {
            return Integer.parseInt(encryptSlideSize);
        }
        return 4;
    }

    private Map<String, Object> getAppConfig() {
        Map<String, Object> appConfig = allAppConfig.get(this.taobaoClient.getAppKey());
        return appConfig;
    }

    public SecurityCore(DefaultTaobaoClient taobaoClient, String randomNum, int corePoolSize, int maxPoolSize, int maxQueue, boolean streetest) {
        this.streetest = streetest;
        this.taobaoClient = taobaoClient;
        this.randomNum = randomNum;
        this.init(corePoolSize, maxPoolSize, maxQueue);
        ApiReporter apiReporter = new ApiReporter();
        apiReporter.initSecret(taobaoClient);
    }

    private void init(int corePoolSize, int maxPoolSize, int maxQueue) {
        if (corePoolSize <= 0 || maxPoolSize <= 0 || maxQueue <= 0 || corePoolSize > maxPoolSize) {
            throw new IllegalArgumentException("param error");
        }
        if (initThreadPoolAtomic.compareAndSet(false, true)) {
            asynUpdateSecret = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxQueue), new NamedThreadFactory("taobao sdk asyn update secret", true), new ThreadPoolExecutor.AbortPolicy());
        }
    }

    public void setRandomNum(String randomNum) {
        this.randomNum = randomNum;
    }

    public SecretContext getSecret(String session, Long secretVersion) throws ApiException {
        SecretContext secretContext = this.getSecret(session, this.generateSecretKey(session, secretVersion));
        if (secretContext != null) {
            if (secretContext.isValid()) {
                return secretContext;
            }
            if (secretContext.isMaxValid()) {
                this.asynUpdateSecret(session, secretVersion);
                return secretContext;
            }
            String cacheKey = this.generateSecretKey(session, secretVersion);
            if (session != null) {
                appUserSecretCache.remove(cacheKey);
            } else {
                appSecretCache.remove(cacheKey);
            }
            return this.callSecretApi(session, secretVersion);
        }
        return this.callSecretApi(session, secretVersion);
    }

    private String generateSecretKey(String session, Long secretVersion) {
        if (session == null) {
            return this.taobaoClient.getAppKey();
        }
        if (secretVersion == null) {
            return session;
        }
        return session + "_" + secretVersion;
    }

    private SecretContext getSecret(String session, String cacheKey) {
        SecretContext secretContext = session != null ? appUserSecretCache.get(cacheKey) : appSecretCache.get(cacheKey);
        return secretContext;
    }

    private SecretContext callSecretApi(String session, Long secretVersion) throws ApiException {
        TopSecretGetResponse response;
        if (StringUtils.isEmpty(this.randomNum)) {
            throw new IllegalArgumentException("randomNum can`t be empty");
        }
        TopSecretGetRequest request = new TopSecretGetRequest();
        request.setRandomNum(this.randomNum);
        request.setSecretVersion(secretVersion);
        if (this.streetest) {
            request.putOtherTextParam("tb_eagleeyex_t", "1");
        }
        if (session != null && session.startsWith("_")) {
            String customerUserId = session.substring(1);
            if (!StringUtils.isDigits(customerUserId)) {
                throw new IllegalArgumentException("session invalid");
            }
            request.setCustomerUserId(Long.valueOf(customerUserId));
            response = this.taobaoClient.execute(request, null);
        } else {
            response = this.taobaoClient.execute(request, session);
        }
        if (response.isSuccess()) {
            Map appConfig = null;
            if (!StringUtils.isEmpty(response.getAppConfig())) {
                appConfig = (Map)TaobaoUtils.jsonToObject(response.getAppConfig());
                allAppConfig.put(this.taobaoClient.getAppKey(), appConfig);
            }
            SecretContext secretContext = new SecretContext();
            if (response.getSecret() != null) {
                long currentTime = System.currentTimeMillis();
                secretContext.setInvalidTime(currentTime + response.getInterval() * 1000L);
                secretContext.setMaxInvalidTime(currentTime + response.getMaxInterval() * 1000L);
                secretContext.setSecret(Base64.decode(response.getSecret()));
                secretContext.setSecretVersion(response.getSecretVersion());
            } else if (appConfig != null && "0".equals(appConfig.get("publish_status"))) {
                this.setNullCache(secretContext);
            }
            String cacheKey = this.generateSecretKey(session, secretVersion);
            if (session != null) {
                appUserSecretCache.put(cacheKey, secretContext);
            } else {
                appSecretCache.put(cacheKey, secretContext);
            }
            return secretContext;
        }
        if ("20005".equals(response.getSubCode())) {
            SecretContext secretContext = new SecretContext();
            this.setNullCache(secretContext);
            String cacheKey = this.generateSecretKey(session, secretVersion);
            if (session != null) {
                appUserSecretCache.put(cacheKey, secretContext);
            } else {
                appSecretCache.put(cacheKey, secretContext);
            }
            return secretContext;
        }
        throw new ApiException(response.getErrorCode(), response.getMsg(), response.getSubCode(), response.getSubMsg());
    }

    private void setNullCache(SecretContext secretContext) {
        long currentTime = System.currentTimeMillis();
        secretContext.setInvalidTime(currentTime + 300000L);
        secretContext.setMaxInvalidTime(currentTime + 600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asynUpdateSecret(final String session, final Long secretVersion) {
        final String cacheKey = this.generateSecretKey(session, secretVersion);
        try {
            Class<SecurityCore> clazz = SecurityCore.class;
            synchronized (SecurityCore.class) {
                if (asynQueueKey.containsKey(cacheKey)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                SecretContext secretContext = this.getSecret(session, this.generateSecretKey(session, secretVersion));
                if (secretContext != null && secretContext.isValid()) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                asynQueueKey.put(cacheKey, emptyValue);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                asynUpdateSecret.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SecurityCore.this.callSecretApi(session, secretVersion);
                        }
                        catch (Exception e) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)"asyn update secret error", (Throwable)e);
                            }
                        }
                        finally {
                            asynQueueKey.remove(cacheKey);
                        }
                    }
                });
            }
        }
        catch (RuntimeException e) {
            asynQueueKey.remove(cacheKey);
            throw e;
        }
    }

    static {
        asynQueueKey = new ConcurrentHashMap();
        emptyValue = new Object();
        initThreadPoolAtomic = new AtomicBoolean(false);
        allAppConfig = new ConcurrentHashMap();
    }
}

