/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.api;

import com.qimencloud.api.AbstractQimenCloudResponse;
import com.qimencloud.api.IQimenCloudRequest;
import com.qimencloud.api.QimenCloudClient;
import com.qimencloud.api.QimenCloudRequest;
import com.qimencloud.api.QimenCloudResponse;
import com.taobao.api.ApiException;
import com.taobao.api.ApiRuleException;
import com.taobao.api.TaobaoParser;
import com.taobao.api.internal.mapping.RequestXmlBodyType;
import com.taobao.api.internal.parser.json.QimenCloudJsonParser;
import com.taobao.api.internal.parser.xml.QimenCloudXmlParser;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.internal.util.WebUtils;
import com.taobao.api.internal.util.XmlWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DingTalkQimenCloudClient
implements QimenCloudClient {
    protected String serverUrl;
    protected String format = "json";
    protected int connectTimeout = 15000;
    protected int readTimeout = 30000;
    protected boolean needCheckRequest = true;
    protected boolean needEnableParser = true;
    protected boolean useGzipEncoding = true;

    public DingTalkQimenCloudClient(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public DingTalkQimenCloudClient(String serverUrl, String format) {
        this(serverUrl);
        this.format = format;
    }

    public DingTalkQimenCloudClient(String serverUrl, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public <T extends AbstractQimenCloudResponse> T execute(IQimenCloudRequest<T> request, String accessToken) throws ApiException {
        long start = System.currentTimeMillis();
        TaobaoParser<T> parser = null;
        if (this.needEnableParser) {
            parser = "xml".equals(this.format) ? new QimenCloudXmlParser<T>(request.getResponseClass()) : new QimenCloudJsonParser<T>(request.getResponseClass());
        }
        if (this.needCheckRequest) {
            try {
                request.check();
            }
            catch (ApiRuleException e) {
                AbstractQimenCloudResponse localResponse = null;
                try {
                    localResponse = (AbstractQimenCloudResponse)request.getResponseClass().newInstance();
                }
                catch (Exception xe) {
                    throw new ApiException(xe);
                }
                localResponse.setCode(e.getErrCode());
                localResponse.setMessage(e.getErrMsg());
                return (T)localResponse;
            }
        }
        String apiBody = null;
        RequestXmlBodyType requestXmlBodyType = request.getClass().getAnnotation(RequestXmlBodyType.class);
        Boolean isXmlBody = requestXmlBodyType != null;
        if (isXmlBody.booleanValue()) {
            XmlWriter writer = new XmlWriter(true, "request", IQimenCloudRequest.class);
            apiBody = writer.write(request);
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap appParams = new TaobaoHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        protocalMustParams.put("timestamp", (Object)new Date(timestamp));
        requestHolder.setProtocalMustParams(protocalMustParams);
        TaobaoHashMap protocalOptParams = new TaobaoHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("v", "2.0");
        protocalOptParams.put("session", accessToken);
        requestHolder.setProtocalOptParams(protocalOptParams);
        String fullUrl = null;
        String traceRequestUrl = null;
        try {
            String realServerUrl = this.getServerUrl(this.serverUrl);
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            String appParamsQuery = WebUtils.buildQuery(appParams, "UTF-8");
            if (isXmlBody.booleanValue()) {
                traceRequestUrl = fullUrl = WebUtils.buildRequestUrl(realServerUrl, appParamsQuery, sysMustQuery, sysOptQuery);
            } else {
                fullUrl = WebUtils.buildRequestUrl(realServerUrl, sysMustQuery, sysOptQuery);
                traceRequestUrl = WebUtils.buildRequestUrl(realServerUrl, appParamsQuery, sysMustQuery, sysOptQuery);
            }
            String rsp = null;
            if (this.useGzipEncoding) {
                request.getHeaderMap().put("Accept-Encoding", "gzip");
            }
            rsp = isXmlBody != false ? WebUtils.doPost(fullUrl, "text/xml;charset=utf-8", apiBody.getBytes("UTF-8"), this.connectTimeout, this.readTimeout, request.getHeaderMap(), null) : WebUtils.doPost(fullUrl, (Map<String, String>)appParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap(), null);
            requestHolder.setResponseBody(rsp);
        }
        catch (IOException e) {
            TaobaoLogger.logApiError("DingTalkApp", request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new ApiException(e);
        }
        AbstractQimenCloudResponse tRsp = null;
        if (this.needEnableParser) {
            tRsp = (AbstractQimenCloudResponse)parser.parse(requestHolder.getResponseBody());
            tRsp.setRequestUrl(traceRequestUrl);
            tRsp.setBody(requestHolder.getResponseBody());
        } else {
            try {
                tRsp = (AbstractQimenCloudResponse)request.getResponseClass().newInstance();
                tRsp.setRequestUrl(traceRequestUrl);
                tRsp.setBody(requestHolder.getResponseBody());
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        if (!tRsp.isPlatformSuccess()) {
            TaobaoLogger.logApiError("DingTalkApp", request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, tRsp.getBody());
        }
        return (T)tRsp;
    }

    @Override
    public QimenCloudResponse execute(QimenCloudRequest request, String accessToken) throws ApiException {
        long start = System.currentTimeMillis();
        TaobaoParser<QimenCloudResponse> parser = null;
        if (this.needEnableParser) {
            parser = "xml".equals(this.format) ? new QimenCloudXmlParser<QimenCloudResponse>(QimenCloudResponse.class) : new QimenCloudJsonParser<QimenCloudResponse>(QimenCloudResponse.class);
        }
        String apiBody = null;
        RequestXmlBodyType requestXmlBodyType = request.getClass().getAnnotation(RequestXmlBodyType.class);
        Boolean isXmlBody = requestXmlBodyType != null;
        if (isXmlBody.booleanValue()) {
            XmlWriter writer = new XmlWriter(true, "request", IQimenCloudRequest.class);
            apiBody = writer.write(request);
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap appParams = new TaobaoHashMap(request.getQueryParams());
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        protocalMustParams.put("timestamp", (Object)new Date(timestamp));
        requestHolder.setProtocalMustParams(protocalMustParams);
        TaobaoHashMap protocalOptParams = new TaobaoHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("v", "2.0");
        protocalOptParams.put("session", accessToken);
        requestHolder.setProtocalOptParams(protocalOptParams);
        String fullUrl = null;
        String traceRequestUrl = null;
        try {
            String realServerUrl = this.getServerUrl(this.serverUrl);
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            String appParamsQuery = WebUtils.buildQuery(appParams, "UTF-8");
            if (isXmlBody.booleanValue()) {
                traceRequestUrl = fullUrl = WebUtils.buildRequestUrl(realServerUrl, appParamsQuery, sysMustQuery, sysOptQuery);
            } else {
                fullUrl = WebUtils.buildRequestUrl(realServerUrl, sysMustQuery, sysOptQuery);
                traceRequestUrl = WebUtils.buildRequestUrl(realServerUrl, appParamsQuery, sysMustQuery, sysOptQuery);
            }
            String rsp = null;
            if (this.useGzipEncoding) {
                request.getHeaderMap().put("Accept-Encoding", "gzip");
            }
            rsp = isXmlBody != false ? WebUtils.doPost(fullUrl, "text/xml;charset=utf-8", apiBody.getBytes("UTF-8"), this.connectTimeout, this.readTimeout, request.getHeaderMap(), null) : WebUtils.doPost(fullUrl, (Map<String, String>)appParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap(), null);
            requestHolder.setResponseBody(rsp);
        }
        catch (IOException e) {
            TaobaoLogger.logApiError("DingTalkApp", request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new ApiException(e);
        }
        QimenCloudResponse tRsp = null;
        if (this.needEnableParser) {
            tRsp = parser.parse(requestHolder.getResponseBody());
            tRsp.setRequestUrl(traceRequestUrl);
            tRsp.setBody(requestHolder.getResponseBody());
        } else {
            try {
                tRsp = new QimenCloudResponse();
                tRsp.setRequestUrl(traceRequestUrl);
                tRsp.setBody(requestHolder.getResponseBody());
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        if (!tRsp.isSuccess()) {
            TaobaoLogger.logApiError("DingTalkApp", request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, tRsp.getBody());
        }
        return tRsp;
    }

    public String getServerUrl(String serverUrl) {
        return serverUrl;
    }

    public void setNeedCheckRequest(boolean needCheckRequest) {
        this.needCheckRequest = needCheckRequest;
    }

    public void setNeedEnableParser(boolean needEnableParser) {
        this.needEnableParser = needEnableParser;
    }

    public void setNeedEnableLogger(boolean needEnableLogger) {
        TaobaoLogger.setNeedEnableLogger(needEnableLogger);
    }

    public void setIgnoreSSLCheck(boolean ignore) {
        WebUtils.setIgnoreSSLCheck(ignore);
    }

    public void setUseGzipEncoding(boolean useGzipEncoding) {
        this.useGzipEncoding = useGzipEncoding;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public <T extends AbstractQimenCloudResponse> T execute(IQimenCloudRequest<T> request) throws ApiException {
        throw new ApiException("\u9489\u9489api\uff0caccessToken\u5fc5\u4f20");
    }

    @Override
    public QimenCloudResponse execute(QimenCloudRequest request) throws ApiException {
        throw new ApiException("\u9489\u9489api\uff0caccessToken\u5fc5\u4f20");
    }
}

