/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api;

import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.internal.cluster.ClusterManager;
import com.taobao.api.internal.cluster.DnsConfig;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.WebUtils;

public class ClusterTaobaoClient
extends DefaultTaobaoClient {
    public ClusterTaobaoClient(String serverUrl, String appKey, String appSecret) throws ApiException {
        super(serverUrl, appKey, appSecret);
        ClusterManager.initRefreshThread(this);
    }

    public ClusterTaobaoClient(String serverUrl, String appKey, String appSecret, String format) throws ApiException {
        super(serverUrl, appKey, appSecret, format);
        ClusterManager.initRefreshThread(this);
    }

    public ClusterTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) throws ApiException {
        super(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout);
        ClusterManager.initRefreshThread(this);
    }

    public ClusterTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String signMethod) throws ApiException {
        super(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout, signMethod);
        ClusterManager.initRefreshThread(this);
    }

    public String getServerUrl(String serverUrl, String apiName, String session, TaobaoHashMap appParams) {
        DnsConfig dnsConfig = ClusterManager.GetDnsConfigFromCache();
        if (dnsConfig == null) {
            return serverUrl;
        }
        return dnsConfig.getBestVipUrl(serverUrl, apiName, session, appParams);
    }

    protected String getSdkVersion() {
        return "top-sdk-java-cluster-20180525";
    }

    static {
        WebUtils.setIgnoreHostCheck(true);
    }
}

