/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.sign;

import com.taobao.api.ApiRuleException;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoUploadRequest;
import com.taobao.api.internal.sign.SignatureValidateResponse;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureValidateRequest
implements TaobaoUploadRequest<SignatureValidateResponse> {
    private TaobaoHashMap udfParams;
    private Long timestamp;
    private String algorithm;
    private FileItem body;
    private String charset;
    private String proxyAppKey;
    private String signature;
    private Map<String, String> headerMap = new TaobaoHashMap();

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setBody(FileItem body) {
        this.body = body;
    }

    public FileItem getBody() {
        return this.body;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setProxyAppKey(String proxyAppKey) {
        this.proxyAppKey = proxyAppKey;
    }

    public String getProxyAppKey() {
        return this.proxyAppKey;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.signature.validate";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("algorithm", this.algorithm);
        txtParams.put("charset", this.charset);
        txtParams.put("proxy_app_key", this.proxyAppKey);
        txtParams.put("signature", this.signature);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    public void putOtherTextParam(String key, String value) {
        if (this.udfParams == null) {
            this.udfParams = new TaobaoHashMap();
        }
        this.udfParams.put(key, value);
    }

    @Override
    public Map<String, FileItem> getFileParams() {
        HashMap<String, FileItem> params = new HashMap<String, FileItem>();
        params.put("body", this.body);
        return params;
    }

    @Override
    public Class<SignatureValidateResponse> getResponseClass() {
        return SignatureValidateResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.body, "body");
        RequestCheckUtils.checkNotEmpty(this.proxyAppKey, "proxyAppKey");
        RequestCheckUtils.checkNotEmpty(this.signature, "signature");
    }

    @Override
    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    @Override
    public String getTargetAppKey() {
        return null;
    }

    @Override
    public String getBatchApiSession() {
        return null;
    }

    @Override
    public void setBatchApiSession(String session) {
    }

    @Override
    public int getBatchApiOrder() {
        return 0;
    }

    @Override
    public void setBatchApiOrder(int order) {
    }
}

