/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api;

import com.taobao.api.internal.cluster.ClusterManager;
import com.taobao.api.internal.cluster.DnsConfig;
import com.taobao.api.internal.util.WebUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpdnsClient {
    private static final AtomicBoolean init = new AtomicBoolean(false);
    private static final Log log = LogFactory.getLog(ClusterManager.class);

    public static void init(String appKey, String appSecret) {
        if (init.compareAndSet(false, true)) {
            WebUtils.setIgnoreHostCheck(true);
            ClusterManager.initRefreshThread(appKey, appSecret);
        }
    }

    public static String getUrl(String url) {
        if (!init.get()) {
            log.error((Object)"Taobao HttpdnsClient is not initialized...");
            return url;
        }
        DnsConfig dnsConfig = ClusterManager.GetDnsConfigFromCache();
        if (dnsConfig == null) {
            return url;
        }
        return dnsConfig.getVipUrl(url);
    }
}

