/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.util;

import com.taobao.api.internal.toplink.embedded.websocket.WebSocket;
import com.taobao.api.internal.toplink.embedded.websocket.impl.WebSocketBase;
import com.taobao.api.internal.toplink.embedded.websocket.util.StringUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.logging.Logger;

public class PacketDumpUtil {
    public static final int FR_DOWN = 1;
    public static final int HS_DOWN = 2;
    public static final int FR_UP = 4;
    public static final int HS_UP = 8;
    public static final int ALL = 15;
    private static Logger log = Logger.getLogger(PacketDumpUtil.class.getName());

    public static boolean isDump(WebSocket ws, int mode) {
        return (((WebSocketBase)ws).getPacketDumpMode() & mode) > 0;
    }

    public static void printPacketDump(String title, ByteBuffer buffer) {
        buffer.mark();
        int count = 0;
        String header = "               4         8        12        16";
        StringBuilder dump = new StringBuilder();
        dump.append(title);
        dump.append("\n");
        dump.append(header);
        dump.append("\n");
        while (buffer.hasRemaining()) {
            byte[] line = new byte[16];
            StringBuilder dumpLine = new StringBuilder();
            dumpLine.append(StringUtil.lpad(Integer.toHexString(16 * count++), 5, "0"));
            dumpLine.append(":");
            int length = Math.min(buffer.remaining(), line.length);
            buffer.get(line, 0, length);
            for (int i = 0; i < length; ++i) {
                if (i % 2 == 0) {
                    dumpLine.append(" ");
                }
                dumpLine.append(StringUtil.lpad(StringUtil.toHexString(line[i]), 2, "0"));
            }
            dumpLine.append(" ");
            dump.append(StringUtil.rpad(dumpLine, header.length() + 3, " ") + PacketDumpUtil.dumpStr(line, length));
            dump.append("\n");
        }
        log.info(dump.toString());
        buffer.reset();
    }

    private static String dumpStr(byte[] bytes, int length) {
        CharBuffer buf = CharBuffer.allocate(length);
        for (int i = 0; i < length; ++i) {
            if (0 <= bytes[i] && bytes[i] <= 31 || bytes[i] == 127 || (bytes[i] & 0x80) > 0) {
                buf.put(i, '.');
                continue;
            }
            buf.put(i, (char)bytes[i]);
        }
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(64);
        buf.put("01234567890-+=\n\rabcdefg".getBytes());
        buf.flip();
        PacketDumpUtil.printPacketDump("TEST", buf);
    }
}

