package com.dingtalk.api.request;

import java.util.Map;
import java.util.List;

import com.taobao.api.ApiRuleException;
import com.dingtalk.api.BaseDingTalkRequest;
import com.dingtalk.api.DingTalkConstants;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoUtils;

import com.dingtalk.api.response.OapiCspaceGetCustomSpaceResponse;

/**
 * TOP DingTalk-API: dingtalk.oapi.cspace.get_custom_space request
 * 
 * @author top auto create
 * @since 1.0, 2018.05.14
 */
public class OapiCspaceGetCustomSpaceRequest extends BaseDingTalkRequest<OapiCspaceGetCustomSpaceResponse> {
	
	

	/** 
	* ISV调用时传入，微应用agentId
	 */
	private String agentId;

	/** 
	* 企业调用时传入，需要为10个字节以内的字符串，仅可包含字母和数字，大小写不敏感
	 */
	private String domain;

	public void setAgentId(String agentId) {
		this.agentId = agentId;
	}

	public String getAgentId() {
		return this.agentId;
	}

	public void setDomain(String domain) {
		this.domain = domain;
	}

	public String getDomain() {
		return this.domain;
	}

	public String getApiMethodName() {
		return "dingtalk.oapi.cspace.get_custom_space";
	}

	public String getApiCallType() {
    	return DingTalkConstants.CALL_TYPE_OAPI;
    }

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("agent_id", this.agentId);
		txtParams.put("domain", this.domain);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OapiCspaceGetCustomSpaceResponse> getResponseClass() {
		return OapiCspaceGetCustomSpaceResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}