/*
 * Decompiled with CFR 0.152.
 */
package com.qimencloud.api;

import com.qimencloud.api.AbstractQimenCloudResponse;
import com.qimencloud.api.IQimenCloudRequest;
import com.qimencloud.api.QimenCloudClient;
import com.qimencloud.api.QimenCloudRequest;
import com.qimencloud.api.QimenCloudResponse;
import com.taobao.api.ApiException;
import com.taobao.api.ApiRuleException;
import com.taobao.api.TaobaoParser;
import com.taobao.api.internal.cluster.ClusterManager;
import com.taobao.api.internal.cluster.DnsConfig;
import com.taobao.api.internal.mapping.RequestXmlBodyType;
import com.taobao.api.internal.parser.json.QimenCloudJsonParser;
import com.taobao.api.internal.parser.xml.QimenCloudXmlParser;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.internal.util.WebUtils;
import com.taobao.api.internal.util.XmlWriter;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultQimenCloudClient
implements QimenCloudClient {
    protected String serverUrl;
    protected String appKey;
    protected String appSecret;
    protected String format = "json";
    protected String signMethod = "hmac-sha256";
    protected int connectTimeout = 15000;
    protected int readTimeout = 30000;
    protected boolean needCheckRequest = true;
    protected boolean needEnableParser = true;
    protected boolean useGzipEncoding = true;
    private boolean isHttpDnsEnabled = false;
    private String originalHttpHost = null;
    private Proxy proxy = null;

    public DefaultQimenCloudClient(String serverUrl, String appKey, String appSecret) {
        this.serverUrl = serverUrl;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public DefaultQimenCloudClient(String serverUrl, String appKey, String appSecret, String format) {
        this(serverUrl, appKey, appSecret);
        this.format = format;
    }

    public DefaultQimenCloudClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, appKey, appSecret, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultQimenCloudClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String signMethod) {
        this(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout);
        this.signMethod = signMethod;
    }

    @Override
    public <T extends AbstractQimenCloudResponse> T execute(IQimenCloudRequest<T> request) throws ApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends AbstractQimenCloudResponse> T execute(IQimenCloudRequest<T> request, String session) throws ApiException {
        long start = System.currentTimeMillis();
        TaobaoParser<T> parser = null;
        if (this.needEnableParser) {
            parser = "xml".equals(this.format) ? new QimenCloudXmlParser<T>(request.getResponseClass()) : new QimenCloudJsonParser<T>(request.getResponseClass());
        }
        if (this.needCheckRequest) {
            try {
                request.check();
            }
            catch (ApiRuleException e) {
                AbstractQimenCloudResponse localResponse = null;
                try {
                    localResponse = (AbstractQimenCloudResponse)request.getResponseClass().newInstance();
                }
                catch (Exception xe) {
                    throw new ApiException(xe);
                }
                localResponse.setCode(e.getErrCode());
                localResponse.setMessage(e.getErrMsg());
                return (T)localResponse;
            }
        }
        String apiBody = null;
        RequestXmlBodyType requestXmlBodyType = request.getClass().getAnnotation(RequestXmlBodyType.class);
        Boolean isXmlBody = requestXmlBodyType != null;
        if (isXmlBody.booleanValue()) {
            XmlWriter writer = new XmlWriter(true, "request", IQimenCloudRequest.class);
            apiBody = writer.write(request);
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap appParams = new TaobaoHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("app_key", this.appKey);
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        protocalMustParams.put("timestamp", (Object)new Date(timestamp));
        requestHolder.setProtocalMustParams(protocalMustParams);
        TaobaoHashMap protocalOptParams = new TaobaoHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("sign_method", this.signMethod);
        protocalOptParams.put("v", "2.0");
        protocalOptParams.put("session", session);
        protocalOptParams.put("target_app_key", request.getTargetAppKey());
        requestHolder.setProtocalOptParams(protocalOptParams);
        String fullUrl = null;
        String traceRequestUrl = null;
        try {
            if (isXmlBody.booleanValue()) {
                protocalMustParams.put("sign", TaobaoUtils.signTopRequestWithBody(requestHolder, apiBody, this.appSecret, this.signMethod));
            } else {
                protocalMustParams.put("sign", TaobaoUtils.signTopRequest(requestHolder, this.appSecret, this.signMethod));
            }
            String realServerUrl = this.getServerUrl(this.serverUrl);
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            String appParamsQuery = WebUtils.buildQuery(appParams, "UTF-8");
            if (isXmlBody.booleanValue()) {
                traceRequestUrl = fullUrl = WebUtils.buildRequestUrl(realServerUrl, appParamsQuery, sysMustQuery, sysOptQuery);
            } else {
                fullUrl = WebUtils.buildRequestUrl(realServerUrl, sysMustQuery, sysOptQuery);
                traceRequestUrl = WebUtils.buildRequestUrl(realServerUrl, appParamsQuery, sysMustQuery, sysOptQuery);
            }
            String rsp = null;
            if (this.useGzipEncoding) {
                request.getHeaderMap().put("Accept-Encoding", "gzip");
            }
            if (this.getTopHttpDnsHost() != null) {
                request.getHeaderMap().put("TOP_HTTP_DNS_HOST", this.getTopHttpDnsHost());
            }
            rsp = isXmlBody != false ? WebUtils.doPost(fullUrl, "text/xml;charset=utf-8", apiBody.getBytes("UTF-8"), this.connectTimeout, this.readTimeout, request.getHeaderMap(), this.getProxy()) : WebUtils.doPost(fullUrl, (Map<String, String>)appParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap(), this.getProxy());
            requestHolder.setResponseBody(rsp);
        }
        catch (IOException e) {
            TaobaoLogger.logApiError(this.appKey, request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new ApiException(e);
        }
        AbstractQimenCloudResponse tRsp = null;
        if (this.needEnableParser) {
            tRsp = (AbstractQimenCloudResponse)parser.parse(requestHolder.getResponseBody());
            tRsp.setRequestUrl(traceRequestUrl);
            tRsp.setBody(requestHolder.getResponseBody());
        } else {
            try {
                tRsp = (AbstractQimenCloudResponse)request.getResponseClass().newInstance();
                tRsp.setRequestUrl(traceRequestUrl);
                tRsp.setBody(requestHolder.getResponseBody());
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        if (!tRsp.isPlatformSuccess()) {
            TaobaoLogger.logApiError(this.appKey, request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, tRsp.getBody());
        }
        return (T)tRsp;
    }

    @Override
    public QimenCloudResponse execute(QimenCloudRequest request) throws ApiException {
        return this.execute(request, null);
    }

    @Override
    public QimenCloudResponse execute(QimenCloudRequest request, String session) throws ApiException {
        long start = System.currentTimeMillis();
        TaobaoParser<QimenCloudResponse> parser = null;
        if (this.needEnableParser) {
            parser = "xml".equals(this.format) ? new QimenCloudXmlParser<QimenCloudResponse>(request.getResponseClass()) : new QimenCloudJsonParser<QimenCloudResponse>(request.getResponseClass());
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap appParams = new TaobaoHashMap(request.getQueryParams());
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("app_key", this.appKey);
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        protocalMustParams.put("timestamp", (Object)new Date(timestamp));
        requestHolder.setProtocalMustParams(protocalMustParams);
        TaobaoHashMap protocalOptParams = new TaobaoHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("sign_method", this.signMethod);
        protocalOptParams.put("v", "2.0");
        protocalOptParams.put("session", session);
        protocalOptParams.put("target_app_key", request.getTargetAppKey());
        requestHolder.setProtocalOptParams(protocalOptParams);
        String apiBody = request.getBody();
        String fullUrl = null;
        String traceRequestUrl = null;
        try {
            if (apiBody != null && !apiBody.isEmpty()) {
                protocalMustParams.put("sign", TaobaoUtils.signTopRequestWithBody(requestHolder, apiBody, this.appSecret, this.signMethod));
            } else {
                protocalMustParams.put("sign", TaobaoUtils.signTopRequest(requestHolder, this.appSecret, this.signMethod));
            }
            String realServerUrl = this.getServerUrl(this.serverUrl);
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            String appParamsQuery = WebUtils.buildQuery(appParams, "UTF-8");
            if (apiBody != null && !apiBody.isEmpty()) {
                fullUrl = WebUtils.buildRequestUrl(realServerUrl, appParamsQuery, sysMustQuery, sysOptQuery);
                traceRequestUrl = WebUtils.buildRequestUrl(realServerUrl, sysMustQuery, sysOptQuery);
            } else {
                fullUrl = WebUtils.buildRequestUrl(realServerUrl, sysMustQuery, sysOptQuery);
                traceRequestUrl = WebUtils.buildRequestUrl(realServerUrl, appParamsQuery, sysMustQuery, sysOptQuery);
            }
            String rsp = null;
            if (this.useGzipEncoding) {
                request.getHeaderMap().put("Accept-Encoding", "gzip");
            }
            if (this.getTopHttpDnsHost() != null) {
                request.getHeaderMap().put("TOP_HTTP_DNS_HOST", this.getTopHttpDnsHost());
            }
            rsp = apiBody != null && !apiBody.isEmpty() ? WebUtils.doPost(fullUrl, "text/xml;charset=utf-8", apiBody.getBytes("UTF-8"), this.connectTimeout, this.readTimeout, request.getHeaderMap(), this.getProxy()) : WebUtils.doPost(fullUrl, (Map<String, String>)appParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap(), this.getProxy());
            requestHolder.setResponseBody(rsp);
        }
        catch (IOException e) {
            TaobaoLogger.logApiError(this.appKey, request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new ApiException(e);
        }
        QimenCloudResponse tRsp = null;
        if (this.needEnableParser) {
            tRsp = parser.parse(requestHolder.getResponseBody());
            tRsp.setRequestUrl(traceRequestUrl);
            tRsp.setBody(requestHolder.getResponseBody());
        } else {
            try {
                tRsp = request.getResponseClass().newInstance();
                tRsp.setRequestUrl(traceRequestUrl);
                tRsp.setBody(requestHolder.getResponseBody());
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        if (!tRsp.isSuccess()) {
            TaobaoLogger.logApiError(this.appKey, request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, tRsp.getBody());
        }
        return tRsp;
    }

    public String getServerUrl(String serverUrl) {
        if (this.isHttpDnsEnabled) {
            DnsConfig dnsConfig = ClusterManager.GetDnsConfigFromCache();
            if (dnsConfig == null) {
                return serverUrl;
            }
            return dnsConfig.getVipUrl(serverUrl);
        }
        return serverUrl;
    }

    public String getTopHttpDnsHost() {
        if (this.isHttpDnsEnabled) {
            return this.originalHttpHost;
        }
        return null;
    }

    public void setNeedCheckRequest(boolean needCheckRequest) {
        this.needCheckRequest = needCheckRequest;
    }

    public void setNeedEnableParser(boolean needEnableParser) {
        this.needEnableParser = needEnableParser;
    }

    public void setNeedEnableLogger(boolean needEnableLogger) {
        TaobaoLogger.setNeedEnableLogger(needEnableLogger);
    }

    public void setIgnoreSSLCheck(boolean ignore) {
        WebUtils.setIgnoreSSLCheck(ignore);
    }

    public void setUseGzipEncoding(boolean useGzipEncoding) {
        this.useGzipEncoding = useGzipEncoding;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public void enableHttpDns() {
        WebUtils.setIgnoreHostCheck(true);
        this.setHttpDnsHost(this.serverUrl);
        ClusterManager.initRefreshThread(this.appKey, this.appSecret);
        this.isHttpDnsEnabled = true;
    }

    public void enableHttpDns(String onlineAppKey, String onlineAppSecret) {
        WebUtils.setIgnoreHostCheck(true);
        this.setHttpDnsHost(this.serverUrl);
        ClusterManager.initRefreshThread(onlineAppKey, onlineAppSecret);
        this.isHttpDnsEnabled = true;
    }

    private void setHttpDnsHost(String serverUrl) {
        if (serverUrl == null || serverUrl.isEmpty()) {
            return;
        }
        try {
            URL url = new URL(serverUrl);
            this.originalHttpHost = url.getHost();
        }
        catch (Exception e) {
            throw new RuntimeException("error serverUrl:" + serverUrl, e);
        }
    }

    public String getAppKey() {
        return this.appKey;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

