package com.dingtalk.api.request;

import java.util.Map;
import java.util.List;

import com.taobao.api.ApiRuleException;
import com.dingtalk.api.BaseDingTalkRequest;
import com.dingtalk.api.DingTalkConstants;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoUtils;

import com.dingtalk.api.response.OapiDepartmentListParentDeptsResponse;

/**
 * TOP DingTalk-API: dingtalk.oapi.department.list_parent_depts request
 * 
 * @author top auto create
 * @since 1.0, 2018.05.09
 */
public class OapiDepartmentListParentDeptsRequest extends BaseDingTalkRequest<OapiDepartmentListParentDeptsResponse> {
	
	

	/** 
	* 用户userId
	 */
	private String userId;

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getUserId() {
		return this.userId;
	}

	public String getApiMethodName() {
		return "dingtalk.oapi.department.list_parent_depts";
	}

	public String getApiCallType() {
    	return DingTalkConstants.CALL_TYPE_OAPI;
    }

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("userId", this.userId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OapiDepartmentListParentDeptsResponse> getResponseClass() {
		return OapiDepartmentListParentDeptsResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}