/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="wrapper", requiresProject=true)
public class MavenWrapperMojo
extends AbstractMojo
implements Contextualizable {
    public static final String DIST_FILENAME_PATH_TEMPLATE = "%s/apache-maven-%s-bin.zip";
    public static final String WRAPPER_PROPERTIES_FILE_NAME = "maven-wrapper.properties";
    public static final String WRAPPER_JAR_FILE_NAME = "maven-wrapper.jar";
    public static final String DISTRIBUTION_URL_PROPERTY = "distributionUrl";
    public static final String SCRIPT_FILENAME_WINDOWS = "mvnw.bat";
    public static final String SCRIPT_FILENAME_UNIX = "mvnw";
    private static final String WRAPPER_TEMPLATES_LOCATION = "com/rimerosolutions/maven/plugins/wrapper/";
    private static final String WRAPPER_PROPERTIES_COMMENTS = "Maven download properties";
    private static final String ENCODING_UTF8 = "UTF-8";
    static final String[] LAUNCHER_FILE_SEPARATORS = new String[]{"\\", "/"};
    static final String[] LAUNCHER_FILE_BASE_NAMES = new String[]{"mvnw.bat", "mvnw"};
    static final String[] LAUNCHERS_PARTS_WINDOWS = new String[]{"mvnw_header.bat", "", "mvnw_footer.bat"};
    static final String[] LAUNCHERS_PARTS_UNIX = new String[]{"mvnw_header", "", "mvnw_footer"};
    static final String[][] LAUNCHERS_PARTS = new String[][]{LAUNCHERS_PARTS_WINDOWS, LAUNCHERS_PARTS_UNIX};
    static final String[] LAUNCHERS_JAR_PREFIXES = new String[]{"set WRAPPER_JAR=\"%MAVEN_PROJECTBASEDIR%\\", "\"$MAVEN_PROJECTBASEDIR/"};
    private PlexusContainer container;
    @Component
    private MavenProject project;
    @Component
    private PluginDescriptor plugin;
    @Parameter(property="baseDistributionUrl", defaultValue="https://repository.apache.org/content/repositories/releases/org/apache/maven/apache-maven")
    private String baseDistributionUrl;
    @Parameter(property="wrapperScriptDirectory", defaultValue="${basedir}")
    private String wrapperScriptDirectory;
    @Parameter(property="wrapperDirectory", defaultValue="${basedir}/maven")
    private String wrapperDirectory;
    @Parameter(property="mavenVersion", required=false)
    private String mavenVersion;

    protected void setPlugin(PluginDescriptor plugin) {
        this.plugin = plugin;
    }

    protected void setMavenVersion(String mavenVersion) {
        this.mavenVersion = mavenVersion;
    }

    protected String getMavenVersion() {
        return this.mavenVersion;
    }

    protected String getWrapperDirectory() {
        return this.wrapperDirectory;
    }

    protected String getWrapperScriptDirectory() {
        return this.wrapperScriptDirectory;
    }

    protected String getBaseDistributionUrl() {
        return this.baseDistributionUrl;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private String composePath(String fileSeparator, Deque<String> folderDeque, String filename) {
        StringBuilder sb = new StringBuilder();
        String folderPath = this.pathFromDequeWithFileSeparator(folderDeque, fileSeparator);
        return sb.append(folderPath).append(filename).toString();
    }

    private String pathFromDequeWithFileSeparator(Deque<String> deque, String separator) {
        Iterator<String> it = deque.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            String pathName = it.next();
            sb.append(pathName);
            sb.append(separator);
        }
        return sb.toString();
    }

    private Deque<String> buildPathDeque(File wrapperDestFolder, File baseDir) {
        File tmp = wrapperDestFolder;
        ArrayDeque<String> pathNameDeque = new ArrayDeque<String>();
        while (!tmp.equals(baseDir)) {
            pathNameDeque.push(tmp.getName());
            tmp = tmp.getParentFile();
        }
        return pathNameDeque;
    }

    public void execute() throws MojoExecutionException {
        try {
            File wrapperSupportFolder;
            File wrapperFolder = new File(this.wrapperScriptDirectory);
            if (!wrapperFolder.exists()) {
                wrapperFolder.mkdirs();
            }
            Artifact mainArtifact = this.plugin.getPluginArtifact();
            if (this.mavenVersion == null) {
                RuntimeInformation runtimeInformation = (RuntimeInformation)this.container.lookup(RuntimeInformation.class);
                this.mavenVersion = runtimeInformation.getMavenVersion();
            }
            if (!(wrapperSupportFolder = new File(this.wrapperDirectory)).exists()) {
                wrapperSupportFolder.mkdirs();
            }
            String baseDirPath = wrapperFolder.getAbsolutePath();
            String wrapperFolderPath = wrapperSupportFolder.getAbsolutePath();
            if (!wrapperFolderPath.startsWith(baseDirPath)) {
                throw new MojoExecutionException("wrapperDirectory folder must be a sub-folder of wrapperScriptDirectory.");
            }
            this.generateWrapperMainArtefacts(wrapperFolder, wrapperSupportFolder);
            this.generateWrapperProperties(wrapperSupportFolder, mainArtifact);
        }
        catch (ComponentLookupException cle) {
            throw new MojoExecutionException("Could not lookup Maven runtime information", (Exception)((Object)cle));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unexpected IO Error", (Exception)ioe);
        }
    }

    private void generateWrapperMainArtefacts(File baseDir, File wrapperDestFolder) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Deque<String> pathNameDeque = this.buildPathDeque(wrapperDestFolder, baseDir);
        for (int i = 0; i < LAUNCHERS_PARTS.length; ++i) {
            String[] launcherOsParts = LAUNCHERS_PARTS[i];
            InputStream[] streams = new InputStream[launcherOsParts.length];
            for (int j = 0; j < launcherOsParts.length; ++j) {
                InputStream mvnLauncherStream;
                String launcherFilePartName = launcherOsParts[j];
                if (launcherFilePartName.equals("")) {
                    String fileSeparator = LAUNCHER_FILE_SEPARATORS[i];
                    String jarPathLocation = this.composePath(fileSeparator, pathNameDeque, WRAPPER_JAR_FILE_NAME);
                    String jarPathPrefix = LAUNCHERS_JAR_PREFIXES[i];
                    String jarPath = jarPathPrefix + jarPathLocation;
                    streams[j] = new ByteArrayInputStream(jarPath.getBytes(ENCODING_UTF8));
                    continue;
                }
                String launcherLocation = WRAPPER_TEMPLATES_LOCATION + launcherFilePartName;
                streams[j] = mvnLauncherStream = classLoader.getResourceAsStream(launcherLocation);
            }
            File launcherFile = new File(baseDir, LAUNCHER_FILE_BASE_NAMES[i]);
            MavenWrapperMojo.streamsToFile(streams, launcherFile);
            if (launcherFile.setExecutable(true)) continue;
            this.getLog().warn((CharSequence)("Could not set executable flag on file: " + launcherFile.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateWrapperProperties(File wrapperSupportFolder, Artifact pluginArtifact) throws IOException {
        FileInputStream is;
        block6: {
            Properties props = new Properties();
            StringBuilder sb = new StringBuilder(this.baseDistributionUrl);
            if (!this.baseDistributionUrl.endsWith("/")) {
                sb.append('/');
            }
            sb.append(DIST_FILENAME_PATH_TEMPLATE);
            props.put(DISTRIBUTION_URL_PROPERTY, String.format(sb.toString(), this.mavenVersion, this.mavenVersion));
            File file = new File(wrapperSupportFolder, WRAPPER_PROPERTIES_FILE_NAME);
            FileOutputStream fileOut = null;
            is = null;
            try {
                is = new FileInputStream(pluginArtifact.getFile());
                MavenWrapperMojo.streamsToFile(new InputStream[]{is}, new File(wrapperSupportFolder, WRAPPER_JAR_FILE_NAME));
                fileOut = new FileOutputStream(file);
                props.store(fileOut, WRAPPER_PROPERTIES_COMMENTS);
                if (fileOut == null) break block6;
            }
            catch (Throwable throwable) {
                if (fileOut != null) {
                    IOUtil.close(fileOut);
                }
                if (is != null) {
                    IOUtil.close((InputStream)is);
                }
                throw throwable;
            }
            IOUtil.close((OutputStream)fileOut);
        }
        if (is != null) {
            IOUtil.close((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void streamsToFile(InputStream[] streams, File filePath) throws IOException {
        FileChannel outChannel = null;
        ReadableByteChannel inChannel = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            outChannel = fos.getChannel();
            for (InputStream stream : streams) {
                try {
                    inChannel = Channels.newChannel(stream);
                    ByteBuffer buffer = ByteBuffer.allocate(1024);
                    while (inChannel.read(buffer) >= 0 || buffer.position() > 0) {
                        buffer.flip();
                        outChannel.write(buffer);
                        buffer.clear();
                    }
                }
                finally {
                    if (stream != null) {
                        IOUtil.close((InputStream)stream);
                    }
                    if (inChannel != null) {
                        inChannel.close();
                    }
                }
            }
        }
        finally {
            if (fos != null) {
                IOUtil.close((OutputStream)fos);
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }
}

