/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownRequestDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownStatesEnum;
import org.apache.directory.api.ldap.extras.extended.gracefulShutdown.GracefulShutdownRequestImpl;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GracefulShutdownGrammar
extends AbstractGrammar<GracefulShutdownContainer> {
    static final Logger LOG = LoggerFactory.getLogger(GracefulShutdownGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static GracefulShutdownGrammar instance = new GracefulShutdownGrammar();

    private GracefulShutdownGrammar() {
        this.setName(GracefulShutdownGrammar.class.getName());
        this.transitions = new GrammarTransition[GracefulShutdownStatesEnum.LAST_GRACEFUL_SHUTDOWN_STATE.ordinal()][256];
        this.transitions[GracefulShutdownStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<GracefulShutdownContainer>(GracefulShutdownStatesEnum.START_STATE, GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), new GrammarAction<GracefulShutdownContainer>("Init GracefulShutdown"){

            @Override
            public void action(GracefulShutdownContainer container) {
                GracefulShutdownRequestDecorator gracefulShutdownRequest = new GracefulShutdownRequestDecorator(LdapApiServiceFactory.getSingleton(), new GracefulShutdownRequestImpl());
                container.setGracefulShutdownRequest(gracefulShutdownRequest);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition<GracefulShutdownContainer>(GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, GracefulShutdownStatesEnum.TIME_OFFLINE_STATE, UniversalTag.INTEGER.getValue(), new GrammarAction<GracefulShutdownContainer>("Set Graceful Shutdown time offline"){

            @Override
            public void action(GracefulShutdownContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int timeOffline = IntegerDecoder.parse(value, 0, 720);
                    if (IS_DEBUG) {
                        LOG.debug("Time Offline = " + timeOffline);
                    }
                    container.getGracefulShutdownRequest().setTimeOffline(timeOffline);
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err(I18n.ERR_04037, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg, ide);
                }
            }
        });
        this.transitions[GracefulShutdownStatesEnum.TIME_OFFLINE_STATE.ordinal()][128] = new GrammarTransition<GracefulShutdownContainer>(GracefulShutdownStatesEnum.TIME_OFFLINE_STATE, GracefulShutdownStatesEnum.DELAY_STATE, 128, new GrammarAction<GracefulShutdownContainer>("Set Graceful Shutdown Delay"){

            @Override
            public void action(GracefulShutdownContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse(value, 0, 86400);
                    if (IS_DEBUG) {
                        LOG.debug("Delay = " + delay);
                    }
                    container.getGracefulShutdownRequest().setDelay(delay);
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err(I18n.ERR_04036, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg, ide);
                }
            }
        });
        this.transitions[GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition<GracefulShutdownContainer>(GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, GracefulShutdownStatesEnum.DELAY_STATE, 128, new GrammarAction<GracefulShutdownContainer>("Set Graceful Shutdown Delay"){

            @Override
            public void action(GracefulShutdownContainer container) throws DecoderException {
                GracefulShutdownContainer gracefulShutdownContainer = container;
                BerValue value = gracefulShutdownContainer.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse(value, 0, 86400);
                    if (IS_DEBUG) {
                        LOG.debug("Delay = " + delay);
                    }
                    gracefulShutdownContainer.getGracefulShutdownRequest().setDelay(delay);
                    gracefulShutdownContainer.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err(I18n.ERR_04036, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg, ide);
                }
            }
        });
    }

    public static GracefulShutdownGrammar getInstance() {
        return instance;
    }
}

