/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.DefaultCentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategyConfigurer;
import org.apereo.cas.authentication.ContextualAuthenticationPolicyFactory;
import org.apereo.cas.authentication.DefaultAuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.policy.AcceptAnyAuthenticationPolicyFactory;
import org.apereo.cas.authentication.policy.RequiredHandlerAuthenticationPolicyFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.services.ServiceContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration(value="casCoreConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=true)
public class CasCoreConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreConfiguration.class);
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private AuditableExecution registeredServiceAccessStrategyEnforcer;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="logoutManager")
    private ObjectProvider<LogoutManager> logoutManager;
    @Autowired
    @Qualifier(value="defaultTicketFactory")
    private ObjectProvider<TicketFactory> ticketFactory;
    @Autowired
    @Qualifier(value="principalFactory")
    private ObjectProvider<PrincipalFactory> principalFactory;
    @Autowired
    @Qualifier(value="protocolTicketCipherExecutor")
    private ObjectProvider<CipherExecutor> cipherExecutor;

    @Bean
    @ConditionalOnMissingBean(name={"authenticationPolicyFactory"})
    public ContextualAuthenticationPolicyFactory<ServiceContext> authenticationPolicyFactory() {
        if (this.casProperties.getAuthn().getPolicy().isRequiredHandlerAuthenticationPolicyEnabled()) {
            return new RequiredHandlerAuthenticationPolicyFactory();
        }
        return new AcceptAnyAuthenticationPolicyFactory();
    }

    @ConditionalOnMissingBean(name={"authenticationServiceSelectionPlan"})
    @Autowired
    @Bean
    public AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan(List<AuthenticationServiceSelectionStrategyConfigurer> configurers) {
        DefaultAuthenticationServiceSelectionPlan plan = new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[0]);
        configurers.forEach(c -> {
            String name = StringUtils.removePattern((String)c.getClass().getSimpleName(), (String)"\\$.+");
            LOGGER.debug("Configuring authentication request service selection strategy plan [{}]", (Object)name);
            c.configureAuthenticationServiceSelectionStrategy((AuthenticationServiceSelectionPlan)plan);
        });
        return plan;
    }

    @Bean
    @Autowired
    @ConditionalOnMissingBean(name={"centralAuthenticationService"})
    public CentralAuthenticationService centralAuthenticationService(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan) {
        return new DefaultCentralAuthenticationService(this.applicationEventPublisher, (TicketRegistry)this.ticketRegistry.getIfAvailable(), (ServicesManager)this.servicesManager.getIfAvailable(), (LogoutManager)this.logoutManager.getIfAvailable(), (TicketFactory)this.ticketFactory.getIfAvailable(), authenticationServiceSelectionPlan, this.authenticationPolicyFactory(), (PrincipalFactory)this.principalFactory.getIfAvailable(), (CipherExecutor<String, String>)((CipherExecutor)this.cipherExecutor.getIfAvailable()), this.registeredServiceAccessStrategyEnforcer);
    }
}

