/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Set;
import java.util.stream.Collectors;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

public interface AuthenticationHandlerResolver
extends Ordered {
    public static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationHandlerResolver.class);

    default public Set<AuthenticationHandler> resolve(Set<AuthenticationHandler> candidateHandlers, AuthenticationTransaction transaction) {
        String handlers = candidateHandlers.stream().map(AuthenticationHandler::getName).collect(Collectors.joining(","));
        LOGGER.debug("Default authentication handlers used for this transaction are [{}]", (Object)handlers);
        return candidateHandlers;
    }

    default public int getOrder() {
        return Integer.MIN_VALUE;
    }

    default public boolean supports(Set<AuthenticationHandler> handlers, AuthenticationTransaction transaction) {
        return !handlers.isEmpty() && transaction != null;
    }
}

