/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.support;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesProperties;
import org.apereo.cas.configuration.model.support.ConnectionPoolingProperties;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.NamedStubPersonAttributeDao;
import org.springframework.scheduling.concurrent.ThreadPoolExecutorFactoryBean;
import org.springframework.util.StringUtils;

public final class Beans {
    public static ThreadPoolExecutorFactoryBean newThreadPoolExecutorFactoryBean(ConnectionPoolingProperties config) {
        ThreadPoolExecutorFactoryBean bean = Beans.newThreadPoolExecutorFactoryBean(config.getMaxSize(), config.getMaxSize());
        bean.setCorePoolSize(config.getMinSize());
        return bean;
    }

    public static ThreadPoolExecutorFactoryBean newThreadPoolExecutorFactoryBean(long keepAlive, long maxSize) {
        ThreadPoolExecutorFactoryBean bean = new ThreadPoolExecutorFactoryBean();
        bean.setMaxPoolSize((int)maxSize);
        bean.setKeepAliveSeconds((int)keepAlive);
        return bean;
    }

    public static IPersonAttributeDao newStubAttributeRepository(PrincipalAttributesProperties p) {
        NamedStubPersonAttributeDao dao = new NamedStubPersonAttributeDao();
        HashMap pdirMap = new HashMap();
        p.getStub().getAttributes().forEach((key, value) -> {
            String[] vals = StringUtils.commaDelimitedListToStringArray((String)value);
            pdirMap.put(key, Arrays.stream(vals).collect(Collectors.toList()));
        });
        dao.setBackingMap(pdirMap);
        return dao;
    }

    public static Duration newDuration(String length) {
        if (NumberUtils.isCreatable((String)length)) {
            return Duration.ofSeconds(Long.parseLong(length));
        }
        return Duration.parse(length);
    }

    @Generated
    private Beans() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

