/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apereo.cas.NoOpCipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CipherExecutor<I, O> {
    public static final Logger LOGGER = LoggerFactory.getLogger(CipherExecutor.class);
    public static final String DEFAULT_CONTENT_ENCRYPTION_ALGORITHM = "A128CBC-HS256";

    public O encode(I var1, Object[] var2);

    default public O encode(I value) {
        return this.encode(value, new Object[0]);
    }

    public O decode(I var1, Object[] var2);

    default public O decode(I value) {
        return this.decode(value, new Object[0]);
    }

    default public Map<String, Object> decode(Map<String, Object> properties, Object[] parameters) {
        HashMap<String, Object> decrypted = new HashMap<String, Object>();
        properties.forEach((key, value) -> {
            try {
                LOGGER.debug("Attempting to decode key [{}]", key);
                O result = this.decode(value, parameters);
                if (result != null) {
                    LOGGER.debug("Decrypted key [{}] successfully", key);
                    decrypted.put((String)key, result);
                }
            }
            catch (ClassCastException e) {
                LOGGER.debug("Value of key {}, is not the correct type, not decrypting, but using value as-is.", key);
                decrypted.put((String)key, value);
            }
        });
        return decrypted;
    }

    default public boolean isEnabled() {
        return true;
    }

    default public String getName() {
        return this.getClass().getSimpleName();
    }

    public static CipherExecutor<Serializable, Serializable> noOp() {
        return NoOpCipherExecutor.getInstance();
    }

    public static CipherExecutor<String, String> noOpOfStringToString() {
        return NoOpCipherExecutor.getInstance();
    }

    public static CipherExecutor<Serializable, String> noOpOfSerializableToString() {
        return NoOpCipherExecutor.getInstance();
    }
}

