/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlan;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.spi.ChainingAuditPrincipalIdProvider;
import org.apereo.cas.audit.spi.CredentialsAsFirstParameterResourceResolver;
import org.apereo.cas.audit.spi.DefaultAuditTrailExecutionPlan;
import org.apereo.cas.audit.spi.DefaultAuditTrailRecordResolutionPlan;
import org.apereo.cas.audit.spi.MessageBundleAwareResourceResolver;
import org.apereo.cas.audit.spi.NullableReturnValueAuditResourceResolver;
import org.apereo.cas.audit.spi.ServiceAccessEnforcementAuditResourceResolver;
import org.apereo.cas.audit.spi.ServiceResourceResolver;
import org.apereo.cas.audit.spi.ShortenedReturnValueAsStringResourceResolver;
import org.apereo.cas.audit.spi.ThreadLocalPrincipalResolver;
import org.apereo.cas.audit.spi.TicketAsFirstParameterResourceResolver;
import org.apereo.cas.audit.spi.TicketValidationResourceResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.audit.AuditProperties;
import org.apereo.cas.configuration.model.core.audit.AuditSlf4jLogProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.inspektr.audit.AuditTrailManagementAspect;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.apereo.inspektr.audit.support.Slf4jLoggingAuditTrailManager;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.apereo.inspektr.common.web.ClientInfoThreadLocalFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Configuration(value="casCoreAuditConfiguration")
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreAuditConfiguration
implements AuditTrailExecutionPlanConfigurer,
AuditTrailRecordResolutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreAuditConfiguration.class);
    private static final String AUDIT_ACTION_SUFFIX_FAILED = "_FAILED";
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public AuditTrailManagementAspect auditTrailManagementAspect(@Qualifier(value="auditTrailExecutionPlan") AuditTrailExecutionPlan auditTrailExecutionPlan, @Qualifier(value="auditTrailRecordResolutionPlan") AuditTrailRecordResolutionPlan auditTrailRecordResolutionPlan) {
        AuditTrailManagementAspect aspect = new AuditTrailManagementAspect(this.casProperties.getAudit().getAppCode(), this.auditablePrincipalResolver(this.auditPrincipalIdProvider()), auditTrailExecutionPlan.getAuditTrailManagers(), auditTrailRecordResolutionPlan.getAuditActionResolvers(), auditTrailRecordResolutionPlan.getAuditResourceResolvers());
        aspect.setFailOnAuditFailures(!this.casProperties.getAudit().isIgnoreAuditFailures());
        return aspect;
    }

    @Autowired
    @ConditionalOnMissingBean(name={"auditTrailRecordResolutionPlan"})
    @Bean
    public AuditTrailRecordResolutionPlan auditTrailRecordResolutionPlan(List<AuditTrailRecordResolutionPlanConfigurer> configurers) {
        DefaultAuditTrailRecordResolutionPlan plan = new DefaultAuditTrailRecordResolutionPlan();
        configurers.forEach(c -> {
            String name = StringUtils.removePattern((String)c.getClass().getSimpleName(), (String)"\\$.+");
            LOGGER.debug("Registering audit trail manager [{}]", (Object)name);
            c.configureAuditTrailRecordResolutionPlan((AuditTrailRecordResolutionPlan)plan);
        });
        return plan;
    }

    @Autowired
    @ConditionalOnMissingBean(name={"auditTrailExecutionPlan"})
    @Bean
    public AuditTrailExecutionPlan auditTrailExecutionPlan(List<AuditTrailExecutionPlanConfigurer> configurers) {
        DefaultAuditTrailExecutionPlan plan = new DefaultAuditTrailExecutionPlan();
        configurers.forEach(c -> {
            String name = StringUtils.removePattern((String)c.getClass().getSimpleName(), (String)"\\$.+");
            LOGGER.debug("Registering audit trail manager [{}]", (Object)name);
            c.configureAuditTrailExecutionPlan((AuditTrailExecutionPlan)plan);
        });
        return plan;
    }

    @Bean
    public FilterRegistrationBean casClientInfoLoggingFilter() {
        AuditProperties audit = this.casProperties.getAudit();
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new ClientInfoThreadLocalFilter());
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setName("CAS Client Info Logging Filter");
        bean.setAsyncSupported(true);
        bean.setOrder(Integer.MIN_VALUE);
        HashMap<String, String> initParams = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)audit.getAlternateClientAddrHeaderName())) {
            initParams.put("alternativeIpAddressHeader", audit.getAlternateClientAddrHeaderName());
        }
        if (StringUtils.isNotBlank((CharSequence)audit.getAlternateServerAddrHeaderName())) {
            initParams.put("alternateServerAddrHeaderName", audit.getAlternateServerAddrHeaderName());
        }
        initParams.put("useServerHostAddress", String.valueOf(audit.isUseServerHostAddress()));
        bean.setInitParameters(initParams);
        return bean;
    }

    @ConditionalOnMissingBean(name={"authenticationActionResolver"})
    @Bean
    public AuditActionResolver authenticationActionResolver() {
        return new DefaultAuditActionResolver("_SUCCESS", AUDIT_ACTION_SUFFIX_FAILED);
    }

    @ConditionalOnMissingBean(name={"ticketCreationActionResolver"})
    @Bean
    public AuditActionResolver ticketCreationActionResolver() {
        return new DefaultAuditActionResolver("_CREATED", "_NOT_CREATED");
    }

    @ConditionalOnMissingBean(name={"ticketValidationActionResolver"})
    @Bean
    public AuditActionResolver ticketValidationActionResolver() {
        return new DefaultAuditActionResolver("D", AUDIT_ACTION_SUFFIX_FAILED);
    }

    @ConditionalOnMissingBean(name={"returnValueResourceResolver"})
    @Bean
    public AuditResourceResolver returnValueResourceResolver() {
        return new ShortenedReturnValueAsStringResourceResolver();
    }

    @ConditionalOnMissingBean(name={"nullableReturnValueResourceResolver"})
    @Bean
    public AuditResourceResolver nullableReturnValueResourceResolver() {
        return new NullableReturnValueAuditResourceResolver(this.returnValueResourceResolver());
    }

    @ConditionalOnMissingBean(name={"serviceAccessEnforcementAuditResourceResolver"})
    @Bean
    public ServiceAccessEnforcementAuditResourceResolver serviceAccessEnforcementAuditResourceResolver() {
        return new ServiceAccessEnforcementAuditResourceResolver();
    }

    @ConditionalOnMissingBean(name={"customAuditActionResolverMap"})
    @Bean
    public Map<String, AuditActionResolver> customAuditActionResolverMap() {
        return new HashMap<String, AuditActionResolver>(0);
    }

    @ConditionalOnMissingBean(name={"customAuditResourceResolverMap"})
    @Bean
    public Map<String, AuditResourceResolver> customAuditResourceResolverMap() {
        return new HashMap<String, AuditResourceResolver>(0);
    }

    @ConditionalOnMissingBean(name={"auditablePrincipalResolver"})
    @Bean
    public PrincipalResolver auditablePrincipalResolver(@Qualifier(value="auditPrincipalIdProvider") AuditPrincipalIdProvider auditPrincipalIdProvider) {
        return new ThreadLocalPrincipalResolver(auditPrincipalIdProvider);
    }

    @ConditionalOnMissingBean(name={"ticketResourceResolver"})
    @Bean
    public AuditResourceResolver ticketResourceResolver() {
        return new TicketAsFirstParameterResourceResolver();
    }

    @ConditionalOnMissingBean(name={"ticketValidationResourceResolver"})
    @Bean
    public AuditResourceResolver ticketValidationResourceResolver() {
        AuditProperties audit = this.casProperties.getAudit();
        if (audit.isIncludeValidationAssertion()) {
            return new TicketValidationResourceResolver();
        }
        return this.ticketResourceResolver();
    }

    @ConditionalOnMissingBean(name={"messageBundleAwareResourceResolver"})
    @Bean
    public AuditResourceResolver messageBundleAwareResourceResolver() {
        return new MessageBundleAwareResourceResolver(this.applicationContext);
    }

    @ConditionalOnMissingBean(name={"auditPrincipalIdProvider"})
    @Bean
    public AuditPrincipalIdProvider auditPrincipalIdProvider() {
        Map resolvers = this.applicationContext.getBeansOfType(AuditPrincipalIdProvider.class, false, true);
        ArrayList providers = new ArrayList(resolvers.values());
        AnnotationAwareOrderComparator.sort(providers);
        return new ChainingAuditPrincipalIdProvider(providers);
    }

    public void configureAuditTrailExecutionPlan(AuditTrailExecutionPlan plan) {
        AuditSlf4jLogProperties audit = this.casProperties.getAudit().getSlf4j();
        Slf4jLoggingAuditTrailManager slf4j = new Slf4jLoggingAuditTrailManager();
        slf4j.setUseSingleLine(audit.isUseSingleLine());
        slf4j.setEntrySeparator(audit.getSinglelineSeparator());
        slf4j.setAuditFormat(audit.getAuditFormat());
        plan.registerAuditTrailManager((AuditTrailManager)slf4j);
    }

    public void configureAuditTrailRecordResolutionPlan(AuditTrailRecordResolutionPlan plan) {
        AuditActionResolver resolver = this.authenticationActionResolver();
        plan.registerAuditActionResolver("AUTHENTICATION_RESOLVER", resolver);
        plan.registerAuditActionResolver("SAVE_SERVICE_ACTION_RESOLVER", resolver);
        DefaultAuditActionResolver defResolver = new DefaultAuditActionResolver();
        plan.registerAuditActionResolver("DESTROY_TICKET_GRANTING_TICKET_RESOLVER", (AuditActionResolver)defResolver);
        plan.registerAuditActionResolver("DESTROY_PROXY_GRANTING_TICKET_RESOLVER", (AuditActionResolver)defResolver);
        AuditActionResolver cResolver = this.ticketCreationActionResolver();
        plan.registerAuditActionResolver("CREATE_PROXY_GRANTING_TICKET_RESOLVER", cResolver);
        plan.registerAuditActionResolver("GRANT_SERVICE_TICKET_RESOLVER", cResolver);
        plan.registerAuditActionResolver("GRANT_PROXY_TICKET_RESOLVER", cResolver);
        plan.registerAuditActionResolver("CREATE_TICKET_GRANTING_TICKET_RESOLVER", cResolver);
        DefaultAuditActionResolver authResolver = new DefaultAuditActionResolver("_TRIGGERED", "");
        plan.registerAuditActionResolver("AUTHENTICATION_EVENT_ACTION_RESOLVER", (AuditActionResolver)authResolver);
        plan.registerAuditActionResolver("VALIDATE_SERVICE_TICKET_RESOLVER", this.ticketValidationActionResolver());
        DefaultAuditActionResolver serviceAccessResolver = new DefaultAuditActionResolver("_TRIGGERED", "");
        plan.registerAuditActionResolver("SERVICE_ACCESS_ENFORCEMENT_ACTION_RESOLVER", (AuditActionResolver)serviceAccessResolver);
        plan.registerAuditResourceResolver("AUTHENTICATION_RESOURCE_RESOLVER", (AuditResourceResolver)new CredentialsAsFirstParameterResourceResolver());
        AuditResourceResolver messageBundleAwareResourceResolver = this.messageBundleAwareResourceResolver();
        plan.registerAuditResourceResolver("CREATE_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER", messageBundleAwareResourceResolver);
        plan.registerAuditResourceResolver("CREATE_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER", messageBundleAwareResourceResolver);
        AuditResourceResolver ticketResourceResolver = this.ticketResourceResolver();
        plan.registerAuditResourceResolver("DESTROY_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER", ticketResourceResolver);
        plan.registerAuditResourceResolver("DESTROY_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER", ticketResourceResolver);
        plan.registerAuditResourceResolver("GRANT_SERVICE_TICKET_RESOURCE_RESOLVER", (AuditResourceResolver)new ServiceResourceResolver());
        plan.registerAuditResourceResolver("GRANT_PROXY_TICKET_RESOURCE_RESOLVER", (AuditResourceResolver)new ServiceResourceResolver());
        plan.registerAuditResourceResolver("VALIDATE_SERVICE_TICKET_RESOURCE_RESOLVER", this.ticketValidationResourceResolver());
        plan.registerAuditResourceResolver("SAVE_SERVICE_RESOURCE_RESOLVER", this.returnValueResourceResolver());
        plan.registerAuditResourceResolver("AUTHENTICATION_EVENT_RESOURCE_RESOLVER", this.nullableReturnValueResourceResolver());
        plan.registerAuditResourceResolver("SERVICE_ACCESS_ENFORCEMENT_RESOURCE_RESOLVER", (AuditResourceResolver)this.serviceAccessEnforcementAuditResourceResolver());
        plan.registerAuditActionResolvers(this.customAuditActionResolverMap());
        plan.registerAuditResourceResolvers(this.customAuditResourceResolverMap());
    }
}

