/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;

public class ServiceAccessEnforcementAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    private static final int ABBREV_LENGTH = 40;

    public String[] resolveFrom(JoinPoint auditableTarget, Object returnValue) {
        Objects.requireNonNull(returnValue, "AuditableExecutionResult must not be null");
        AuditableExecutionResult serviceAccessCheckResult = (AuditableExecutionResult)AuditableExecutionResult.class.cast(returnValue);
        String accessCheckOutcome = "Service Access " + BooleanUtils.toString((boolean)serviceAccessCheckResult.isExecutionFailure(), (String)"Denied", (String)"Granted");
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("result", (Object)accessCheckOutcome);
        serviceAccessCheckResult.getService().ifPresent(service -> builder.append("service", (Object)StringUtils.abbreviate((String)service.getId(), (int)40)));
        serviceAccessCheckResult.getAuthentication().ifPresent(authn -> builder.append("principal", (Object)authn.getPrincipal()));
        serviceAccessCheckResult.getRegisteredService().ifPresent(regSvc -> builder.append("requiredAttributes", (Object)regSvc.getAccessStrategy().getRequiredAttributes()));
        return new String[]{builder.toString()};
    }
}

