/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import lombok.Generated;
import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalPrincipalResolver
implements PrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadLocalPrincipalResolver.class);
    private final AuditPrincipalIdProvider auditPrincipalIdProvider;

    public String resolveFrom(JoinPoint auditTarget, Object returnValue) {
        LOGGER.trace("Resolving principal at audit point [{}]", (Object)auditTarget);
        return this.getCurrentPrincipal(returnValue, null);
    }

    public String resolveFrom(JoinPoint auditTarget, Exception exception) {
        LOGGER.trace("Resolving principal at audit point [{}] with thrown exception [{}]", (Object)auditTarget, (Object)exception);
        return this.getCurrentPrincipal(null, exception);
    }

    public String resolve() {
        return "audit:unknown";
    }

    private String getCurrentPrincipal(Object returnValue, Exception exception) {
        Authentication authn = AuthenticationCredentialsThreadLocalBinder.getCurrentAuthentication();
        String principal = this.auditPrincipalIdProvider.getPrincipalIdFrom(authn, returnValue, exception);
        if (principal == null) {
            principal = AuthenticationCredentialsThreadLocalBinder.getCurrentCredentialIdsAsString();
        }
        return principal != null ? principal : "audit:unknown";
    }

    @Generated
    public ThreadLocalPrincipalResolver(AuditPrincipalIdProvider auditPrincipalIdProvider) {
        this.auditPrincipalIdProvider = auditPrincipalIdProvider;
    }
}

