/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AcceptUsersAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.handler.support.HttpBasedServiceCredentialsAuthenticationHandler;
import org.apereo.cas.authentication.handler.support.jaas.JaasAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.PersonDirectoryPrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.ProxyingPrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordPolicyProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.generic.AcceptAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casCoreAuthenticationHandlersConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreAuthenticationHandlersConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreAuthenticationHandlersConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="supportsTrustStoreSslSocketFactoryHttpClient")
    private HttpClient supportsTrustStoreSslSocketFactoryHttpClient;
    @Autowired(required=false)
    @Qualifier(value="acceptPasswordPolicyConfiguration")
    private PasswordPolicyConfiguration acceptPasswordPolicyConfiguration;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @ConditionalOnProperty(prefix="cas.sso", name={"proxyAuthnEnabled"}, havingValue="true", matchIfMissing=true)
    @Bean
    public AuthenticationHandler proxyAuthenticationHandler() {
        return new HttpBasedServiceCredentialsAuthenticationHandler(null, this.servicesManager, this.proxyPrincipalFactory(), Integer.valueOf(Integer.MIN_VALUE), this.supportsTrustStoreSslSocketFactoryHttpClient);
    }

    @ConditionalOnMissingBean(name={"proxyPrincipalFactory"})
    @Bean
    public PrincipalFactory proxyPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"proxyPrincipalResolver"})
    @Bean
    public PrincipalResolver proxyPrincipalResolver() {
        return new ProxyingPrincipalResolver(this.proxyPrincipalFactory());
    }

    @RefreshScope
    @Bean
    public AuthenticationHandler acceptUsersAuthenticationHandler() {
        AcceptAuthenticationProperties props = this.casProperties.getAuthn().getAccept();
        AcceptUsersAuthenticationHandler h = new AcceptUsersAuthenticationHandler(props.getName(), this.servicesManager, this.acceptUsersPrincipalFactory(), null, this.getParsedUsers());
        h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)props.getPasswordEncoder()));
        if (this.acceptPasswordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.acceptPasswordPolicyConfiguration);
        }
        h.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)props.getCredentialCriteria()));
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)props.getPrincipalTransformation()));
        PasswordPolicyProperties passwordPolicy = props.getPasswordPolicy();
        h.setPasswordPolicyHandlingStrategy(CoreAuthenticationUtils.newPasswordPolicyHandlingStrategy((PasswordPolicyProperties)props.getPasswordPolicy()));
        if (passwordPolicy.isEnabled()) {
            PasswordPolicyConfiguration cfg = new PasswordPolicyConfiguration(passwordPolicy);
            if (passwordPolicy.isAccountStateHandlingEnabled()) {
                cfg.setAccountStateHandler((response, configuration) -> new ArrayList(0));
            } else {
                LOGGER.debug("Handling account states is disabled via CAS configuration");
            }
            h.setPasswordPolicyConfiguration(cfg);
        }
        return h;
    }

    @ConditionalOnMissingBean(name={"acceptUsersPrincipalFactory"})
    @Bean
    public PrincipalFactory acceptUsersPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    private Map<String, String> getParsedUsers() {
        Pattern pattern = Pattern.compile("::");
        String usersProperty = this.casProperties.getAuthn().getAccept().getUsers();
        if (StringUtils.isNotBlank((CharSequence)usersProperty) && usersProperty.contains(pattern.pattern())) {
            return Stream.of(usersProperty.split(",")).map(pattern::split).collect(Collectors.toMap(userAndPassword -> userAndPassword[0], userAndPassword -> userAndPassword[1]));
        }
        return new HashMap<String, String>(0);
    }

    @ConditionalOnMissingBean(name={"proxyAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @ConditionalOnProperty(prefix="cas.sso", name={"proxyAuthnEnabled"}, havingValue="true", matchIfMissing=true)
    public AuthenticationEventExecutionPlanConfigurer proxyAuthenticationEventExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(this.proxyAuthenticationHandler(), this.proxyPrincipalResolver());
    }

    @Configuration(value="jaasAuthenticationConfiguration")
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public class JaasAuthenticationConfiguration {
        @Autowired
        @Qualifier(value="attributeRepository")
        private ObjectProvider<IPersonAttributeDao> attributeRepository;

        @ConditionalOnMissingBean(name={"jaasPrincipalFactory"})
        @Bean
        public PrincipalFactory jaasPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }

        @Bean
        @ConditionalOnMissingBean(name={"jaasPersonDirectoryPrincipalResolvers"})
        public List<PrincipalResolver> jaasPersonDirectoryPrincipalResolvers() {
            return CasCoreAuthenticationHandlersConfiguration.this.casProperties.getAuthn().getJaas().stream().filter(jaas -> StringUtils.isNotBlank((CharSequence)jaas.getRealm())).map(jaas -> new PersonDirectoryPrincipalResolver((IPersonAttributeDao)this.attributeRepository.getIfAvailable(), this.jaasPrincipalFactory(), jaas.getPrincipal().isReturnNull(), (String)StringUtils.defaultIfBlank((CharSequence)jaas.getPrincipal().getPrincipalAttribute(), (CharSequence)CasCoreAuthenticationHandlersConfiguration.this.casProperties.getPersonDirectory().getPrincipalAttribute()))).collect(Collectors.toList());
        }

        @ConditionalOnMissingBean(name={"jaasAuthenticationHandlers"})
        @RefreshScope
        @Bean
        public List<AuthenticationHandler> jaasAuthenticationHandlers() {
            return CasCoreAuthenticationHandlersConfiguration.this.casProperties.getAuthn().getJaas().stream().filter(jaas -> StringUtils.isNotBlank((CharSequence)jaas.getRealm())).map(jaas -> {
                JaasAuthenticationHandler h = new JaasAuthenticationHandler(jaas.getName(), CasCoreAuthenticationHandlersConfiguration.this.servicesManager, this.jaasPrincipalFactory(), Integer.valueOf(jaas.getOrder()));
                h.setKerberosKdcSystemProperty(jaas.getKerberosKdcSystemProperty());
                h.setKerberosRealmSystemProperty(jaas.getKerberosRealmSystemProperty());
                h.setRealm(jaas.getRealm());
                h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)jaas.getPasswordEncoder()));
                if (StringUtils.isNotBlank((CharSequence)jaas.getLoginConfigType())) {
                    h.setLoginConfigType(jaas.getLoginConfigType());
                }
                if (StringUtils.isNotBlank((CharSequence)jaas.getLoginConfigurationFile())) {
                    h.setLoginConfigurationFile(new File(jaas.getLoginConfigurationFile()));
                }
                PasswordPolicyProperties passwordPolicy = jaas.getPasswordPolicy();
                h.setPasswordPolicyHandlingStrategy(CoreAuthenticationUtils.newPasswordPolicyHandlingStrategy((PasswordPolicyProperties)jaas.getPasswordPolicy()));
                if (passwordPolicy.isEnabled()) {
                    LOGGER.debug("Password policy is enabled for JAAS. Constructing password policy configuration for [{}]", (Object)jaas.getRealm());
                    PasswordPolicyConfiguration cfg = new PasswordPolicyConfiguration(passwordPolicy);
                    if (passwordPolicy.isAccountStateHandlingEnabled()) {
                        cfg.setAccountStateHandler((response, configuration) -> new ArrayList(0));
                    } else {
                        LOGGER.debug("Handling account states is disabled via CAS configuration");
                    }
                    h.setPasswordPolicyConfiguration(cfg);
                }
                h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)jaas.getPrincipalTransformation()));
                h.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)jaas.getCredentialCriteria()));
                return h;
            }).collect(Collectors.toList());
        }

        @ConditionalOnMissingBean(name={"jaasAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        public AuthenticationEventExecutionPlanConfigurer jaasAuthenticationEventExecutionPlanConfigurer() {
            return plan -> plan.registerAuthenticationHandlerWithPrincipalResolvers(this.jaasAuthenticationHandlers(), this.jaasPersonDirectoryPrincipalResolvers());
        }
    }
}

