/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.AuthenticationManager;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.AuthenticationPreProcessor;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.BasicCredentialMetaData;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerResolver;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.exceptions.UnresolvedPrincipalException;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.support.events.authentication.CasAuthenticationPolicyFailureEvent;
import org.apereo.cas.support.events.authentication.CasAuthenticationPrincipalResolvedEvent;
import org.apereo.cas.support.events.authentication.CasAuthenticationTransactionFailureEvent;
import org.apereo.cas.support.events.authentication.CasAuthenticationTransactionStartedEvent;
import org.apereo.cas.support.events.authentication.CasAuthenticationTransactionSuccessfulEvent;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class PolicyBasedAuthenticationManager
implements AuthenticationManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyBasedAuthenticationManager.class);
    private final AuthenticationEventExecutionPlan authenticationEventExecutionPlan;
    private final boolean principalResolutionFailureFatal;
    private final ApplicationEventPublisher eventPublisher;

    protected void invokeAuthenticationPostProcessors(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        LOGGER.debug("Invoking authentication post processors for authentication transaction");
        Collection pops = this.authenticationEventExecutionPlan.getAuthenticationPostProcessors(transaction);
        Collection supported = pops.stream().filter(processor -> transaction.getCredentials().stream().filter(arg_0 -> ((AuthenticationPostProcessor)processor).supports(arg_0)).findFirst().isPresent()).collect(Collectors.toList());
        for (AuthenticationPostProcessor p : supported) {
            p.process(builder, transaction);
        }
    }

    protected void populateAuthenticationMetadataAttributes(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        LOGGER.debug("Invoking authentication metadata populators for authentication transaction");
        Collection<AuthenticationMetaDataPopulator> pops = this.getAuthenticationMetadataPopulatorsForTransaction(transaction);
        pops.forEach(populator -> transaction.getCredentials().stream().filter(arg_0 -> ((AuthenticationMetaDataPopulator)populator).supports(arg_0)).forEach(credential -> populator.populateAttributes(builder, transaction)));
    }

    protected void addAuthenticationMethodAttribute(AuthenticationBuilder builder, Authentication authentication) {
        authentication.getSuccesses().values().forEach(result -> builder.addAttribute("authenticationMethod", (Object)result.getHandlerName()));
    }

    protected Principal resolvePrincipal(AuthenticationHandler handler, PrincipalResolver resolver, Credential credential, Principal principal) {
        if (resolver.supports(credential)) {
            try {
                Principal p = resolver.resolve(credential, Optional.ofNullable(principal), Optional.ofNullable(handler));
                LOGGER.debug("[{}] resolved [{}] from [{}]", new Object[]{resolver, p, credential});
                return p;
            }
            catch (Exception e) {
                LOGGER.error("[{}] failed to resolve principal from [{}]", new Object[]{resolver, credential, e});
            }
        } else {
            LOGGER.warn("[{}] is configured to use [{}] but it does not support [{}], which suggests a configuration problem.", new Object[]{handler.getName(), resolver, credential});
        }
        return null;
    }

    @Audit(action="AUTHENTICATION", actionResolverName="AUTHENTICATION_RESOLVER", resourceResolverName="AUTHENTICATION_RESOURCE_RESOLVER")
    @Timed(name="AUTHENTICATE_TIMER")
    @Metered(name="AUTHENTICATE_METER")
    @Counted(name="AUTHENTICATE_COUNT", monotonic=true)
    public Authentication authenticate(AuthenticationTransaction transaction) throws AuthenticationException {
        boolean result = this.invokeAuthenticationPreProcessors(transaction);
        if (!result) {
            LOGGER.warn("An authentication pre-processor could not successfully process the authentication transaction");
            throw new AuthenticationException("Authentication pre-processor has failed to process transaction");
        }
        AuthenticationCredentialsThreadLocalBinder.bindCurrent(transaction.getCredentials());
        AuthenticationBuilder builder = this.authenticateInternal(transaction);
        AuthenticationCredentialsThreadLocalBinder.bindCurrent(builder);
        Authentication authentication = builder.build();
        this.addAuthenticationMethodAttribute(builder, authentication);
        this.populateAuthenticationMetadataAttributes(builder, transaction);
        this.invokeAuthenticationPostProcessors(builder, transaction);
        Authentication auth = builder.build();
        Principal principal = auth.getPrincipal();
        if (principal instanceof NullPrincipal) {
            throw new UnresolvedPrincipalException(auth);
        }
        LOGGER.info("Authenticated principal [{}] with attributes [{}] via credentials [{}].", new Object[]{principal.getId(), principal.getAttributes(), transaction.getCredentials()});
        AuthenticationCredentialsThreadLocalBinder.bindCurrent(auth);
        return auth;
    }

    protected boolean invokeAuthenticationPreProcessors(AuthenticationTransaction transaction) {
        LOGGER.debug("Invoking authentication pre processors for authentication transaction");
        Collection pops = this.authenticationEventExecutionPlan.getAuthenticationPreProcessors(transaction);
        Collection supported = pops.stream().filter(processor -> transaction.getCredentials().stream().filter(arg_0 -> ((AuthenticationPreProcessor)processor).supports(arg_0)).findFirst().isPresent()).collect(Collectors.toList());
        boolean processed = true;
        Iterator it = supported.iterator();
        while (processed && it.hasNext()) {
            AuthenticationPreProcessor processor2 = (AuthenticationPreProcessor)it.next();
            processed = processor2.process(transaction);
        }
        return processed;
    }

    protected void authenticateAndResolvePrincipal(AuthenticationBuilder builder, Credential credential, PrincipalResolver resolver, AuthenticationHandler handler) throws GeneralSecurityException, PreventedException {
        String resolverName;
        this.publishEvent((ApplicationEvent)new CasAuthenticationTransactionStartedEvent((Object)this, credential));
        AuthenticationHandlerExecutionResult result = handler.authenticate(credential);
        String authenticationHandlerName = handler.getName();
        builder.addSuccess(authenticationHandlerName, result);
        LOGGER.debug("Authentication handler [{}] successfully authenticated [{}]", (Object)authenticationHandlerName, (Object)credential);
        this.publishEvent((ApplicationEvent)new CasAuthenticationTransactionSuccessfulEvent((Object)this, credential));
        Principal principal = result.getPrincipal();
        String string = resolverName = resolver != null ? resolver.getClass().getSimpleName() : "N/A";
        if (resolver == null) {
            LOGGER.debug("No principal resolution is configured for [{}]. Falling back to handler principal [{}]", (Object)authenticationHandlerName, (Object)principal);
        } else if ((principal = this.resolvePrincipal(handler, resolver, credential, principal)) == null) {
            if (this.principalResolutionFailureFatal) {
                LOGGER.warn("Principal resolution handled by [{}] produced a null principal for: [{}]CAS is configured to treat principal resolution failures as fatal.", (Object)resolverName, (Object)credential);
                throw new UnresolvedPrincipalException();
            }
            LOGGER.warn("Principal resolution handled by [{}] produced a null principal. This is likely due to misconfiguration or missing attributes; CAS will attempt to use the principal produced by the authentication handler, if any.", (Object)resolver.getClass().getSimpleName());
        }
        if (principal == null) {
            LOGGER.warn("Principal resolution for authentication by [{}] produced a null principal.", (Object)authenticationHandlerName);
        } else {
            builder.setPrincipal(principal);
        }
        LOGGER.debug("Final principal resolved for this authentication event is [{}]", (Object)principal);
        this.publishEvent((ApplicationEvent)new CasAuthenticationPrincipalResolvedEvent((Object)this, principal));
    }

    protected Set<AuthenticationHandler> getAuthenticationHandlersForThisTransaction(AuthenticationTransaction transaction) {
        Set handlers = this.authenticationEventExecutionPlan.getAuthenticationHandlersForTransaction(transaction);
        LOGGER.debug("Candidate/Registered authentication handlers for this transaction are [{}]", (Object)handlers);
        Collection handlerResolvers = this.authenticationEventExecutionPlan.getAuthenticationHandlerResolvers(transaction);
        LOGGER.debug("Authentication handler resolvers for this transaction are [{}]", (Object)handlerResolvers);
        Set resolvedHandlers = handlerResolvers.stream().filter(r -> r.supports(handlers, transaction)).map(r -> r.resolve(handlers, transaction)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
        if (resolvedHandlers.isEmpty()) {
            LOGGER.debug("Authentication handler resolvers produced no candidate authentication handler. Using the default handler resolver instead...");
            DefaultAuthenticationHandlerResolver defaultHandlerResolver = new DefaultAuthenticationHandlerResolver();
            if (defaultHandlerResolver.supports(handlers, transaction)) {
                resolvedHandlers.addAll(defaultHandlerResolver.resolve(handlers, transaction));
            }
        }
        if (resolvedHandlers.isEmpty()) {
            throw new GeneralSecurityException("No authentication handlers could be resolved to support the authentication transaction");
        }
        LOGGER.debug("Resolved and finalized authentication handlers to carry out this authentication transaction are [{}]", (Object)resolvedHandlers);
        return resolvedHandlers;
    }

    protected PrincipalResolver getPrincipalResolverLinkedToHandlerIfAny(AuthenticationHandler handler, AuthenticationTransaction transaction) {
        return this.authenticationEventExecutionPlan.getPrincipalResolverForAuthenticationTransaction(handler, transaction);
    }

    protected Collection<AuthenticationMetaDataPopulator> getAuthenticationMetadataPopulatorsForTransaction(AuthenticationTransaction transaction) {
        return this.authenticationEventExecutionPlan.getAuthenticationMetadataPopulators(transaction);
    }

    protected void publishEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationBuilder authenticateInternal(AuthenticationTransaction transaction) throws AuthenticationException {
        Collection credentials = transaction.getCredentials();
        LOGGER.debug("Authentication credentials provided for this transaction are [{}]", (Object)credentials);
        if (credentials.isEmpty()) {
            LOGGER.error("Resolved authentication handlers for this transaction are empty");
            throw new AuthenticationException("Resolved credentials for this transaction are empty");
        }
        DefaultAuthenticationBuilder builder = new DefaultAuthenticationBuilder(NullPrincipal.getInstance());
        credentials.forEach(cred -> builder.addCredential(new BasicCredentialMetaData((Credential)cred)));
        Set<AuthenticationHandler> handlerSet = this.getAuthenticationHandlersForThisTransaction(transaction);
        LOGGER.debug("Candidate resolved authentication handlers for this transaction are [{}]", handlerSet);
        if (handlerSet.isEmpty()) {
            LOGGER.error("Resolved authentication handlers for this transaction are empty");
            throw new AuthenticationException(builder.getFailures(), builder.getSuccesses());
        }
        try {
            Iterator it = credentials.iterator();
            AuthenticationCredentialsThreadLocalBinder.clearInProgressAuthentication();
            while (it.hasNext()) {
                Credential credential = (Credential)it.next();
                LOGGER.debug("Attempting to authenticate credential [{}]", (Object)credential);
                Iterator<AuthenticationHandler> itHandlers = handlerSet.iterator();
                boolean proceedWithNextHandler = true;
                while (proceedWithNextHandler && itHandlers.hasNext()) {
                    AuthenticationHandler handler = itHandlers.next();
                    if (handler.supports(credential)) {
                        try {
                            PrincipalResolver resolver = this.getPrincipalResolverLinkedToHandlerIfAny(handler, transaction);
                            LOGGER.debug("Attempting authentication of [{}] using [{}]", (Object)credential.getId(), (Object)handler.getName());
                            this.authenticateAndResolvePrincipal(builder, credential, resolver, handler);
                            AuthenticationCredentialsThreadLocalBinder.bindInProgress(builder.build());
                            Pair<Boolean, Set<Throwable>> failures = this.evaluateAuthenticationPolicies(builder.build(), transaction);
                            proceedWithNextHandler = (Boolean)failures.getKey() == false;
                        }
                        catch (Exception e) {
                            LOGGER.error("Authentication has failed. Credentials may be incorrect or CAS cannot find authentication handler that supports [{}] of type [{}]. Examine the configuration to ensure a method of authentication is defined and analyze CAS logs at DEBUG level to trace the authentication event.", (Object)credential, (Object)credential.getClass().getSimpleName());
                            this.handleAuthenticationException(e, handler.getName(), builder);
                            proceedWithNextHandler = true;
                        }
                        continue;
                    }
                    LOGGER.debug("Authentication handler [{}] does not support the credential type [{}]. Trying next...", (Object)handler.getName(), (Object)credential);
                }
            }
            this.evaluateFinalAuthentication(builder, transaction);
            DefaultAuthenticationBuilder defaultAuthenticationBuilder = builder;
            return defaultAuthenticationBuilder;
        }
        finally {
            AuthenticationCredentialsThreadLocalBinder.clearInProgressAuthentication();
        }
    }

    protected void evaluateFinalAuthentication(AuthenticationBuilder builder, AuthenticationTransaction transaction) throws AuthenticationException {
        if (builder.getSuccesses().isEmpty()) {
            this.publishEvent((ApplicationEvent)new CasAuthenticationTransactionFailureEvent((Object)this, builder.getFailures(), transaction.getCredentials()));
            throw new AuthenticationException(builder.getFailures(), builder.getSuccesses());
        }
        Authentication authentication = builder.build();
        Pair<Boolean, Set<Throwable>> failures = this.evaluateAuthenticationPolicies(authentication, transaction);
        if (!((Boolean)failures.getKey()).booleanValue()) {
            this.publishEvent((ApplicationEvent)new CasAuthenticationPolicyFailureEvent((Object)this, builder.getFailures(), transaction, authentication));
            ((Set)failures.getValue()).forEach(e -> this.handleAuthenticationException((Throwable)e, e.getClass().getSimpleName(), builder));
            throw new AuthenticationException(builder.getFailures(), builder.getSuccesses());
        }
    }

    protected Pair<Boolean, Set<Throwable>> evaluateAuthenticationPolicies(Authentication authentication, AuthenticationTransaction transaction) {
        LinkedHashSet failures = new LinkedHashSet();
        Collection policies = this.authenticationEventExecutionPlan.getAuthenticationPolicies(transaction);
        policies.forEach(p -> {
            try {
                String simpleName = p.getClass().getSimpleName();
                LOGGER.debug("Executing authentication policy [{}]", (Object)simpleName);
                if (!p.isSatisfiedBy(authentication)) {
                    failures.add(new AuthenticationException("Unable to satisfy authentication policy " + simpleName));
                }
            }
            catch (GeneralSecurityException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
                failures.add(e.getCause());
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
                failures.add(e);
            }
        });
        return Pair.of((Object)failures.isEmpty(), failures);
    }

    protected void handleAuthenticationException(Throwable ex, String name, AuthenticationBuilder builder) {
        Throwable e = ex;
        if (ex instanceof UndeclaredThrowableException) {
            e = ((UndeclaredThrowableException)ex).getUndeclaredThrowable();
        }
        StringBuilder msg = new StringBuilder(StringUtils.defaultString((String)e.getMessage()));
        if (e.getCause() != null) {
            msg.append(" / ").append(e.getCause().getMessage());
        }
        if (e instanceof GeneralSecurityException) {
            LOGGER.debug("[{}] exception details: [{}].", (Object)name, (Object)msg);
            builder.addFailure(name, e);
        } else {
            LOGGER.error("[{}]: [{}]", (Object)name, (Object)msg);
            builder.addFailure(name, e);
        }
    }

    @Generated
    public PolicyBasedAuthenticationManager(AuthenticationEventExecutionPlan authenticationEventExecutionPlan, boolean principalResolutionFailureFatal, ApplicationEventPublisher eventPublisher) {
        this.authenticationEventExecutionPlan = authenticationEventExecutionPlan;
        this.principalResolutionFailureFatal = principalResolutionFailureFatal;
        this.eventPublisher = eventPublisher;
    }

    @Generated
    public AuthenticationEventExecutionPlan getAuthenticationEventExecutionPlan() {
        return this.authenticationEventExecutionPlan;
    }

    @Generated
    public boolean isPrincipalResolutionFailureFatal() {
        return this.principalResolutionFailureFatal;
    }

    @Generated
    public ApplicationEventPublisher getEventPublisher() {
        return this.eventPublisher;
    }
}

