/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationAttributeReleasePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticationAttributeReleasePolicy
implements AuthenticationAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthenticationAttributeReleasePolicy.class);
    private Collection<String> attributesToRelease;
    @Nonnull
    private Set<String> attributesToNeverRelease = new HashSet<String>();

    public void addAttributesToNeverRelease(Collection<String> attrs) {
        if (attrs != null) {
            this.attributesToNeverRelease.addAll(attrs);
        }
    }

    public Map<String, Object> getAuthenticationAttributesForRelease(@Nonnull Authentication authentication) {
        HashMap<String, Object> attrs = new HashMap<String, Object>(authentication.getAttributes());
        attrs.keySet().removeAll(this.attributesToNeverRelease);
        if (this.attributesToRelease != null && !this.attributesToRelease.isEmpty()) {
            attrs.keySet().retainAll(this.attributesToRelease);
        }
        return attrs;
    }

    @Generated
    public void setAttributesToRelease(Collection<String> attributesToRelease) {
        this.attributesToRelease = attributesToRelease;
    }

    @Generated
    public void setAttributesToNeverRelease(@Nonnull Set<String> attributesToNeverRelease) {
        if (attributesToNeverRelease == null) {
            throw new NullPointerException("attributesToNeverRelease is marked @NonNull but is null");
        }
        this.attributesToNeverRelease = attributesToNeverRelease;
    }
}

