/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import lombok.Generated;
import org.apereo.cas.configuration.model.support.mfa.BaseMultifactorProviderProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.support.GenericApplicationContext;

public abstract class AbstractMultifactorAuthenticationProviderFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMultifactorAuthenticationProviderFactory.class);
    private static final String TARGET_BEAN_NAME_KEY = "targetBeanName";
    private static final String SCOPED_TARGET_PREFIX = "scopedTarget.";
    private static final String PROPERTIES_KEY = "properties";
    private static final String PROVIDER_NAME_SUFFIX = "-provider";
    private final GenericApplicationContext applicationContext;
    private final String factoryBeanName;

    protected <T extends MultifactorAuthenticationProvider> T getProvider(String id) {
        String name = this.name(id);
        if (this.applicationContext.containsBean(name)) {
            return (T)((MultifactorAuthenticationProvider)this.applicationContext.getBean(name));
        }
        return null;
    }

    protected void registerInstanceBean(BaseMultifactorProviderProperties props) {
        String providerName = this.name(props.getId());
        RootBeanDefinition bean = ((RootBeanDefinition)this.applicationContext.getBeanDefinition(this.factoryBeanName)).cloneBeanDefinition();
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        propertyValues.add(TARGET_BEAN_NAME_KEY, (Object)SCOPED_TARGET_PREFIX.concat(providerName));
        bean.setPropertyValues(propertyValues);
        LOGGER.debug("Registering provider bean [{}]", (Object)bean);
        this.applicationContext.registerBeanDefinition(providerName, (BeanDefinition)bean);
        RootBeanDefinition scoped = ((RootBeanDefinition)this.applicationContext.getBeanDefinition(SCOPED_TARGET_PREFIX.concat(this.factoryBeanName))).cloneBeanDefinition();
        MutablePropertyValues scopedProps = new MutablePropertyValues();
        scopedProps.addPropertyValue(PROPERTIES_KEY, (Object)props);
        scoped.setPropertyValues(scopedProps);
        LOGGER.debug("Registering scoped provider bean[{}]", (Object)scoped);
        this.applicationContext.registerBeanDefinition(SCOPED_TARGET_PREFIX.concat(providerName), (BeanDefinition)scoped);
    }

    private String name(String id) {
        return id.concat(PROVIDER_NAME_SUFFIX);
    }

    @Generated
    public AbstractMultifactorAuthenticationProviderFactory(GenericApplicationContext applicationContext, String factoryBeanName) {
        this.applicationContext = applicationContext;
        this.factoryBeanName = factoryBeanName;
    }
}

