/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMultifactorAuthenticationProviderBypass
implements MultifactorAuthenticationProviderBypass {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMultifactorAuthenticationProviderBypass.class);
    private static final long serialVersionUID = 3720922341350004543L;
    private final MultifactorAuthenticationProviderBypassProperties bypassProperties;
    private final Pattern httpRequestRemoteAddressPattern;
    private final Set<Pattern> httpRequestHeaderPatterns;

    public DefaultMultifactorAuthenticationProviderBypass(MultifactorAuthenticationProviderBypassProperties bypassProperties) {
        this.bypassProperties = bypassProperties;
        this.httpRequestRemoteAddressPattern = StringUtils.isNotBlank((CharSequence)bypassProperties.getHttpRequestRemoteAddress()) ? RegexUtils.createPattern((String)bypassProperties.getHttpRequestRemoteAddress()) : RegexUtils.MATCH_NOTHING_PATTERN;
        Set values = org.springframework.util.StringUtils.commaDelimitedListToSet((String)bypassProperties.getHttpRequestHeaders());
        this.httpRequestHeaderPatterns = values.stream().map(RegexUtils::createPattern).collect(Collectors.toSet());
    }

    public boolean shouldMultifactorAuthenticationProviderExecute(Authentication authentication, RegisteredService registeredService, MultifactorAuthenticationProvider provider, HttpServletRequest request) {
        Principal principal = authentication.getPrincipal();
        LOGGER.debug("Evaluating multifactor authentication bypass properties for principal [{}], service [{}] and provider [{}]", new Object[]{principal.getId(), registeredService, provider});
        boolean bypassByPrincipal = this.locateMatchingAttributeBasedOnPrincipalAttributes(this.bypassProperties, principal);
        if (bypassByPrincipal) {
            LOGGER.debug("Bypass rules for principal [{}] indicate the request may be ignored", (Object)principal.getId());
            return false;
        }
        boolean bypassByAuthn = this.locateMatchingAttributeBasedOnAuthenticationAttributes(this.bypassProperties, authentication);
        if (bypassByAuthn) {
            LOGGER.debug("Bypass rules for authentication for principal [{}] indicate the request may be ignored", (Object)principal.getId());
            return false;
        }
        boolean bypassByAuthnMethod = this.locateMatchingAttributeValue("authenticationMethod", this.bypassProperties.getAuthenticationMethodName(), authentication.getAttributes(), false);
        if (bypassByAuthnMethod) {
            LOGGER.debug("Bypass rules for authentication method [{}] indicate the request may be ignored", (Object)this.bypassProperties.getAuthenticationMethodName());
            return false;
        }
        boolean bypassByHandlerName = this.locateMatchingAttributeValue("successfulAuthenticationHandlers", this.bypassProperties.getAuthenticationHandlerName(), authentication.getAttributes(), false);
        if (bypassByHandlerName) {
            LOGGER.debug("Bypass rules for authentication handlers [{}] indicate the request may be ignored", (Object)this.bypassProperties.getAuthenticationHandlerName());
            return false;
        }
        boolean bypassByCredType = this.locateMatchingCredentialType(authentication, this.bypassProperties.getCredentialClassType());
        if (bypassByCredType) {
            LOGGER.debug("Bypass rules for credential types [{}] indicate the request may be ignored", (Object)this.bypassProperties.getCredentialClassType());
            return false;
        }
        boolean bypassByHttpRequest = this.locateMatchingHttpRequest(authentication, request);
        if (bypassByHttpRequest) {
            LOGGER.debug("Bypass rules for http request indicate the request may be ignored for [{}]", (Object)principal.getId());
            return false;
        }
        return !this.locateMatchingRegisteredServiceForBypass(authentication, registeredService);
    }

    protected boolean locateMatchingRegisteredServiceForBypass(Authentication authentication, RegisteredService registeredService) {
        if (registeredService != null && registeredService.getMultifactorPolicy() != null) {
            return registeredService.getMultifactorPolicy().isBypassEnabled();
        }
        return false;
    }

    protected boolean locateMatchingCredentialType(Authentication authentication, String credentialClassType) {
        return StringUtils.isNotBlank((CharSequence)credentialClassType) && authentication.getCredentials().stream().filter(e -> e.getCredentialClass().getName().matches(credentialClassType)).findAny().isPresent();
    }

    protected boolean locateMatchingAttributeBasedOnAuthenticationAttributes(MultifactorAuthenticationProviderBypassProperties bypass, Authentication authn) {
        return this.locateMatchingAttributeValue(bypass.getAuthenticationAttributeName(), bypass.getAuthenticationAttributeValue(), authn.getAttributes());
    }

    protected boolean locateMatchingAttributeBasedOnPrincipalAttributes(MultifactorAuthenticationProviderBypassProperties bypass, Principal principal) {
        return this.locateMatchingAttributeValue(bypass.getPrincipalAttributeName(), bypass.getPrincipalAttributeValue(), principal.getAttributes());
    }

    protected boolean locateMatchingAttributeValue(String attrName, String attrValue, Map<String, Object> attributes) {
        return this.locateMatchingAttributeValue(attrName, attrValue, attributes, true);
    }

    protected boolean locateMatchingAttributeValue(String attrName, String attrValue, Map<String, Object> attributes, boolean matchIfNoValueProvided) {
        LOGGER.debug("Locating matching attribute [{}] with value [{}] amongst the attribute collection [{}]", new Object[]{attrName, attrValue, attributes});
        if (StringUtils.isBlank((CharSequence)attrName)) {
            LOGGER.debug("Failed to match since attribute name is undefined");
            return false;
        }
        Set names = attributes.entrySet().stream().filter(e -> {
            LOGGER.debug("Attempting to match [{}] against [{}]", (Object)attrName, e.getKey());
            return ((String)e.getKey()).matches(attrName);
        }).collect(Collectors.toSet());
        LOGGER.debug("Found [{}] attributes relevant for multifactor authentication bypass", (Object)names.size());
        if (names.isEmpty()) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)attrValue)) {
            LOGGER.debug("No attribute value to match is provided; Match result is set to [{}]", (Object)matchIfNoValueProvided);
            return matchIfNoValueProvided;
        }
        Set values = names.stream().filter(e -> {
            Set valuesCol = CollectionUtils.toCollection(e.getValue());
            LOGGER.debug("Matching attribute [{}] with values [{}] against [{}]", new Object[]{e.getKey(), valuesCol, attrValue});
            return valuesCol.stream().filter(v -> v.toString().matches(attrValue)).findAny().isPresent();
        }).collect(Collectors.toSet());
        LOGGER.debug("Matching attribute values remaining are [{}]", values);
        return !values.isEmpty();
    }

    protected boolean locateMatchingHttpRequest(Authentication authentication, HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)this.bypassProperties.getHttpRequestRemoteAddress())) {
            if (this.httpRequestRemoteAddressPattern.matcher(request.getRemoteAddr()).find()) {
                LOGGER.debug("Http request remote address [{}] matches [{}]", (Object)this.bypassProperties.getHttpRequestRemoteAddress(), (Object)request.getRemoteAddr());
                return true;
            }
            if (this.httpRequestRemoteAddressPattern.matcher(request.getRemoteHost()).find()) {
                LOGGER.debug("Http request remote host [{}] matches [{}]", (Object)this.bypassProperties.getHttpRequestRemoteAddress(), (Object)request.getRemoteHost());
                return true;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.bypassProperties.getHttpRequestHeaders())) {
            ArrayList headerNames = Collections.list(request.getHeaderNames());
            boolean matched = this.httpRequestHeaderPatterns.stream().anyMatch(pattern -> headerNames.stream().anyMatch(name -> pattern.matcher((CharSequence)name).matches()));
            if (matched) {
                LOGGER.debug("Http request remote headers [{}] match [{}]", headerNames, (Object)this.bypassProperties.getHttpRequestHeaders());
                return true;
            }
        }
        return false;
    }
}

