/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.config;

import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.configuration.CasConfigurationPropertiesEnvironmentManager;
import org.apereo.cas.configuration.DefaultCasConfigurationPropertiesSourceLocator;
import org.apereo.cas.configuration.api.CasConfigurationPropertiesSourceLocator;
import org.apereo.cas.configuration.support.CasConfigurationJasyptCipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;

@Profile(value={"standalone"})
@ConditionalOnProperty(value={"spring.cloud.config.enabled"}, havingValue="false")
@Configuration(value="casCoreBootstrapStandaloneLocatorConfiguration")
public class CasCoreBootstrapStandaloneLocatorConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreBootstrapStandaloneLocatorConfiguration.class);
    @Autowired
    private ConfigurationPropertiesBindingPostProcessor binder;
    @Autowired
    private Environment environment;

    @ConditionalOnMissingBean(name={"casConfigurationPropertiesSourceLocator"})
    @Bean
    public CasConfigurationPropertiesSourceLocator casConfigurationPropertiesSourceLocator() {
        return new DefaultCasConfigurationPropertiesSourceLocator(this.casConfigurationCipherExecutor(), this.configurationPropertiesEnvironmentManager());
    }

    @ConditionalOnMissingBean(name={"casConfigurationCipherExecutor"})
    @Bean
    public CipherExecutor<String, String> casConfigurationCipherExecutor() {
        return new CasConfigurationJasyptCipherExecutor(this.environment);
    }

    @ConditionalOnMissingBean(name={"configurationPropertiesEnvironmentManager"})
    @Bean
    public CasConfigurationPropertiesEnvironmentManager configurationPropertiesEnvironmentManager() {
        return new CasConfigurationPropertiesEnvironmentManager(this.binder, this.environment);
    }
}

