/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.configuration.CasConfigurationPropertiesEnvironmentManager;
import org.apereo.cas.configuration.CasCoreConfigurationUtils;
import org.apereo.cas.configuration.api.CasConfigurationPropertiesSourceLocator;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class DefaultCasConfigurationPropertiesSourceLocator
implements CasConfigurationPropertiesSourceLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasConfigurationPropertiesSourceLocator.class);
    private final CipherExecutor<String, String> configurationCipherExecutor;
    private final CasConfigurationPropertiesEnvironmentManager casConfigurationPropertiesEnvironmentManager;

    @Override
    public PropertySource<?> locate(Environment environment, ResourceLoader resourceLoader) {
        CompositePropertySource compositePropertySource = new CompositePropertySource("casCompositePropertySource");
        File configFile = this.casConfigurationPropertiesEnvironmentManager.getStandaloneProfileConfigurationFile();
        if (configFile != null) {
            PropertySource<?> sourceStandalone = this.loadSettingsFromStandaloneConfigFile(configFile);
            compositePropertySource.addPropertySource(sourceStandalone);
        }
        File config = this.casConfigurationPropertiesEnvironmentManager.getStandaloneProfileConfigurationDirectory();
        LOGGER.debug("Located CAS standalone configuration directory at [{}]", (Object)config);
        if (config.isDirectory() && config.exists()) {
            PropertySource<?> sourceProfiles = this.loadSettingsByApplicationProfiles(environment, config);
            compositePropertySource.addPropertySource(sourceProfiles);
        } else {
            LOGGER.info("Configuration directory [{}] is not a directory or cannot be found at the specific path", (Object)config);
        }
        PropertySource<?> sourceYaml = this.loadEmbeddedYamlOverriddenProperties(resourceLoader);
        compositePropertySource.addPropertySource(sourceYaml);
        return compositePropertySource;
    }

    private PropertySource<?> loadSettingsFromStandaloneConfigFile(File configFile) {
        Properties props = new Properties();
        try (BufferedReader r = Files.newBufferedReader(configFile.toPath(), StandardCharsets.UTF_8);){
            LOGGER.debug("Located CAS standalone configuration file at [{}]", (Object)configFile);
            props.load(r);
            LOGGER.debug("Found settings [{}] in file [{}]", props.keySet(), (Object)configFile);
            props.putAll(this.decryptProperties(props));
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return new PropertiesPropertySource("standaloneConfigurationFileProperties", props);
    }

    private PropertySource<?> loadSettingsByApplicationProfiles(Environment environment, File config) {
        Properties props = new Properties();
        List<String> profiles = this.getApplicationProfiles(environment);
        String regex = DefaultCasConfigurationPropertiesSourceLocator.buildPatternForConfigurationFileDiscovery(config, profiles);
        Collection<File> configFiles = DefaultCasConfigurationPropertiesSourceLocator.scanForConfigurationFilesByPattern(config, regex);
        LOGGER.info("Configuration files found at [{}] are [{}] under profile(s) [{}]", new Object[]{config, configFiles, environment.getActiveProfiles()});
        configFiles.forEach(Unchecked.consumer(f -> {
            LOGGER.debug("Loading configuration file [{}]", f);
            if (f.getName().toLowerCase().endsWith("yml")) {
                Map pp = CasCoreConfigurationUtils.loadYamlProperties(new Resource[]{new FileSystemResource(f)});
                LOGGER.debug("Found settings [{}] in YAML file [{}]", pp.keySet(), f);
                props.putAll(this.decryptProperties(pp));
            } else {
                Properties pp = new Properties();
                pp.load(Files.newBufferedReader(f.toPath(), StandardCharsets.UTF_8));
                LOGGER.debug("Found settings [{}] in file [{}]", pp.keySet(), f);
                props.putAll(this.decryptProperties(pp));
            }
        }));
        return new PropertiesPropertySource("applicationProfilesProperties", props);
    }

    private PropertySource<?> loadEmbeddedYamlOverriddenProperties(ResourceLoader resourceLoader) {
        Properties props = new Properties();
        Resource resource = resourceLoader.getResource("classpath:/application.yml");
        if (resource != null && resource.exists()) {
            Map pp = CasCoreConfigurationUtils.loadYamlProperties(resource);
            if (pp.isEmpty()) {
                LOGGER.debug("No properties were located inside [{}]", (Object)resource);
            } else {
                LOGGER.info("Found settings [{}] in YAML file [{}]", pp.keySet(), (Object)resource);
                props.putAll(this.decryptProperties(pp));
            }
        }
        return new PropertiesPropertySource("embeddedYamlOverriddenProperties", props);
    }

    private static Collection<File> scanForConfigurationFilesByPattern(File config, String regex) {
        return FileUtils.listFiles((File)config, (IOFileFilter)new RegexFileFilter(regex, IOCase.INSENSITIVE), (IOFileFilter)TrueFileFilter.INSTANCE).stream().sorted(Comparator.comparing(File::getName)).collect(Collectors.toList());
    }

    private Map<String, Object> decryptProperties(Map properties) {
        return this.configurationCipherExecutor.decode(properties, new Object[0]);
    }

    private static String buildPatternForConfigurationFileDiscovery(File config, List<String> profiles) {
        String propertyNames = profiles.stream().collect(Collectors.joining("|"));
        String profiledProperties = profiles.stream().map(p -> String.format("application-%s", p)).collect(Collectors.joining("|"));
        String regex = String.format("(%s|%s|application)\\.(yml|properties)", propertyNames, profiledProperties);
        LOGGER.debug("Looking for configuration files at [{}] that match the pattern [{}]", (Object)config, (Object)regex);
        return regex;
    }

    private List<String> getApplicationProfiles(Environment environment) {
        ArrayList<String> profiles = new ArrayList<String>();
        profiles.add(this.casConfigurationPropertiesEnvironmentManager.getApplicationName());
        profiles.addAll(Arrays.stream(environment.getActiveProfiles()).collect(Collectors.toList()));
        return profiles;
    }

    @Generated
    public DefaultCasConfigurationPropertiesSourceLocator(CipherExecutor<String, String> configurationCipherExecutor, CasConfigurationPropertiesEnvironmentManager casConfigurationPropertiesEnvironmentManager) {
        this.configurationCipherExecutor = configurationCipherExecutor;
        this.casConfigurationPropertiesEnvironmentManager = casConfigurationPropertiesEnvironmentManager;
    }
}

