/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.listener;

import java.util.ArrayList;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.configuration.CasConfigurationPropertiesEnvironmentManager;
import org.apereo.cas.support.events.config.CasConfigurationModifiedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;

public class CasConfigurationEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasConfigurationEventListener.class);
    @Autowired
    private ConfigurationPropertiesBindingPostProcessor binder;
    @Autowired(required=false)
    private ContextRefresher contextRefresher;
    @Autowired
    private ApplicationContext applicationContext;
    private final CasConfigurationPropertiesEnvironmentManager configurationPropertiesEnvironmentManager;

    public CasConfigurationEventListener(CasConfigurationPropertiesEnvironmentManager configurationPropertiesEnvironmentManager) {
        this.configurationPropertiesEnvironmentManager = configurationPropertiesEnvironmentManager;
    }

    @EventListener
    public void handleRefreshEvent(EnvironmentChangeEvent event) {
        LOGGER.debug("Received event [{}]", (Object)event);
        this.rebind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void handleConfigurationModifiedEvent(CasConfigurationModifiedEvent event) {
        if (this.contextRefresher == null) {
            LOGGER.warn("Unable to refresh application context, since no refresher is available");
            return;
        }
        if (event.isEligibleForContextRefresh()) {
            LOGGER.info("Received event [{}]. Refreshing CAS configuration...", (Object)event);
            Set keys = null;
            try {
                keys = this.contextRefresher.refresh();
                LOGGER.debug("Refreshed the following settings: [{}].", (Object)keys);
            }
            catch (Exception e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
            }
            finally {
                this.rebind();
                LOGGER.info("CAS finished rebinding configuration with new settings [{}]", ObjectUtils.defaultIfNull((Object)keys, new ArrayList(0)));
            }
        }
    }

    private void rebind() {
        LOGGER.info("Refreshing CAS configuration. Stand by...");
        if (this.configurationPropertiesEnvironmentManager != null) {
            this.configurationPropertiesEnvironmentManager.rebindCasConfigurationProperties(this.applicationContext);
        } else {
            CasConfigurationPropertiesEnvironmentManager.rebindCasConfigurationProperties((ConfigurationPropertiesBindingPostProcessor)this.binder, (ApplicationContext)this.applicationContext);
        }
    }
}

