/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logging.config;

import java.util.Collection;
import java.util.HashMap;
import javax.servlet.Filter;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logging.web.ThreadContextMDCServletFilter;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casLoggingConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasLoggingConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasLoggingConfiguration.class);
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CookieRetrievingCookieGenerator> ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;

    @Bean
    public FilterRegistrationBean threadContextMDCServletFilter() {
        HashMap initParams = new HashMap();
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new ThreadContextMDCServletFilter(this.ticketRegistrySupport, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable()));
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setInitParameters(initParams);
        bean.setName("threadContextMDCServletFilter");
        bean.setOrder(-2147483647);
        return bean;
    }
}

