/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.LogoutMessageCreator;
import org.apereo.cas.logout.LogoutRequest;
import org.apereo.cas.logout.SingleLogoutServiceMessageHandler;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.CompressionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogoutManager
implements LogoutManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLogoutManager.class);
    private final LogoutMessageCreator logoutMessageBuilder;
    private final SingleLogoutServiceMessageHandler singleLogoutServiceMessageHandler;
    private final boolean singleLogoutCallbacksDisabled;
    private final LogoutExecutionPlan logoutExecutionPlan;

    public List<LogoutRequest> performLogout(TicketGrantingTicket ticket) {
        LOGGER.info("Performing logout operations for [{}]", (Object)ticket.getId());
        if (this.singleLogoutCallbacksDisabled) {
            LOGGER.info("Single logout callbacks are disabled");
            return new ArrayList<LogoutRequest>(0);
        }
        List<LogoutRequest> logoutRequests = this.performLogoutForTicket(ticket);
        this.logoutExecutionPlan.getLogoutHandlers().forEach(h -> {
            LOGGER.debug("Invoking logout handler [{}] to process ticket [{}]", (Object)h.getClass().getSimpleName(), (Object)ticket.getId());
            h.handle(ticket);
        });
        LOGGER.info("[{}] logout requests were processed", (Object)logoutRequests.size());
        return logoutRequests;
    }

    private List<LogoutRequest> performLogoutForTicket(TicketGrantingTicket ticketToBeLoggedOut) {
        Stream<Map> streamServices = Stream.concat(Stream.of(ticketToBeLoggedOut.getServices()), Stream.of(ticketToBeLoggedOut.getProxyGrantingTickets()));
        return streamServices.map(Map::entrySet).flatMap(Collection::stream).filter(entry -> entry.getValue() instanceof WebApplicationService).map(entry -> {
            WebApplicationService service = (WebApplicationService)entry.getValue();
            LOGGER.debug("Handling single logout callback for [{}]", (Object)service);
            return this.singleLogoutServiceMessageHandler.handle(service, (String)entry.getKey());
        }).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String createFrontChannelLogoutMessage(LogoutRequest logoutRequest) {
        String logoutMessage = this.logoutMessageBuilder.create(logoutRequest);
        LOGGER.trace("Attempting to deflate the logout message [{}]", (Object)logoutMessage);
        return CompressionUtils.deflate((String)logoutMessage);
    }

    @Generated
    public DefaultLogoutManager(LogoutMessageCreator logoutMessageBuilder, SingleLogoutServiceMessageHandler singleLogoutServiceMessageHandler, boolean singleLogoutCallbacksDisabled, LogoutExecutionPlan logoutExecutionPlan) {
        this.logoutMessageBuilder = logoutMessageBuilder;
        this.singleLogoutServiceMessageHandler = singleLogoutServiceMessageHandler;
        this.singleLogoutCallbacksDisabled = singleLogoutCallbacksDisabled;
        this.logoutExecutionPlan = logoutExecutionPlan;
    }
}

