/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSingleLogoutServiceLogoutUrlBuilder
implements SingleLogoutServiceLogoutUrlBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSingleLogoutServiceLogoutUrlBuilder.class);
    private final UrlValidator urlValidator;

    public Collection<URL> determineLogoutUrl(RegisteredService registeredService, WebApplicationService singleLogoutService) {
        URL serviceLogoutUrl = registeredService.getLogoutUrl();
        if (serviceLogoutUrl != null) {
            LOGGER.debug("Logout request will be sent to [{}] for service [{}]", (Object)serviceLogoutUrl, (Object)singleLogoutService);
            return CollectionUtils.wrap((Object)serviceLogoutUrl);
        }
        String originalUrl = singleLogoutService.getOriginalUrl();
        if (this.urlValidator.isValid(originalUrl)) {
            LOGGER.debug("Logout request will be sent to [{}] for service [{}]", (Object)originalUrl, (Object)singleLogoutService);
            URL url = new URL(originalUrl);
            return CollectionUtils.wrap((Object)url);
        }
        LOGGER.debug("Logout request will not be sent; The URL [{}] for service [{}] is not valid", (Object)originalUrl, (Object)singleLogoutService);
        return new ArrayList<URL>();
    }

    @Generated
    public DefaultSingleLogoutServiceLogoutUrlBuilder(UrlValidator urlValidator) {
        this.urlValidator = urlValidator;
    }
}

