/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.DefaultLogoutRequest;
import org.apereo.cas.logout.LogoutHttpMessage;
import org.apereo.cas.logout.LogoutMessageCreator;
import org.apereo.cas.logout.LogoutRequest;
import org.apereo.cas.logout.LogoutRequestStatus;
import org.apereo.cas.logout.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.SingleLogoutServiceMessageHandler;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.HttpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSingleLogoutServiceMessageHandler
implements SingleLogoutServiceMessageHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSingleLogoutServiceMessageHandler.class);
    private final HttpClient httpClient;
    private final LogoutMessageCreator logoutMessageBuilder;
    private final ServicesManager servicesManager;
    private final SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder;
    private boolean asynchronous = true;
    private final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;

    public Collection<LogoutRequest> handle(WebApplicationService singleLogoutService, String ticketId) {
        if (singleLogoutService.isLoggedOutAlready()) {
            LOGGER.debug("Service [{}] is already logged out.", (Object)singleLogoutService);
            return new ArrayList<LogoutRequest>(0);
        }
        WebApplicationService selectedService = (WebApplicationService)WebApplicationService.class.cast(this.authenticationRequestServiceSelectionStrategies.resolveService((Service)singleLogoutService));
        LOGGER.debug("Processing logout request for service [{}]...", (Object)selectedService);
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)selectedService);
        if (!DefaultSingleLogoutServiceMessageHandler.serviceSupportsSingleLogout(registeredService)) {
            LOGGER.debug("Service [{}] does not support single logout.", (Object)selectedService);
            return new ArrayList<LogoutRequest>(0);
        }
        LOGGER.debug("Service [{}] supports single logout and is found in the registry as [{}]. Proceeding...", (Object)selectedService, (Object)registeredService);
        Collection logoutUrls = this.singleLogoutServiceLogoutUrlBuilder.determineLogoutUrl(registeredService, selectedService);
        LOGGER.debug("Prepared logout url [{}] for service [{}]", (Object)logoutUrls, (Object)selectedService);
        if (logoutUrls == null || logoutUrls.isEmpty()) {
            LOGGER.debug("Service [{}] does not support logout operations given no logout url could be determined.", (Object)selectedService);
            return new ArrayList<LogoutRequest>(0);
        }
        LOGGER.debug("Creating logout request for [{}] and ticket id [{}]", (Object)selectedService, (Object)ticketId);
        return this.createLogoutRequests(ticketId, selectedService, registeredService, logoutUrls);
    }

    private Collection<LogoutRequest> createLogoutRequests(String ticketId, WebApplicationService selectedService, RegisteredService registeredService, Collection<URL> logoutUrls) {
        return logoutUrls.stream().map(url -> this.createLogoutRequest(ticketId, selectedService, registeredService, (URL)url)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private LogoutRequest createLogoutRequest(String ticketId, WebApplicationService selectedService, RegisteredService registeredService, URL logoutUrl) {
        DefaultLogoutRequest logoutRequest = new DefaultLogoutRequest(ticketId, selectedService, logoutUrl);
        LOGGER.debug("Logout request [{}] created for [{}] and ticket id [{}]", new Object[]{logoutRequest, selectedService, ticketId});
        RegisteredService.LogoutType type = registeredService.getLogoutType() == null ? RegisteredService.LogoutType.BACK_CHANNEL : registeredService.getLogoutType();
        LOGGER.debug("Logout type registered for [{}] is [{}]", (Object)selectedService, (Object)type);
        if (type == RegisteredService.LogoutType.BACK_CHANNEL) {
            if (this.performBackChannelLogout(logoutRequest)) {
                logoutRequest.setStatus(LogoutRequestStatus.SUCCESS);
            } else {
                logoutRequest.setStatus(LogoutRequestStatus.FAILURE);
                LOGGER.warn("Logout message is not sent to [{}]; Continuing processing...", (Object)selectedService);
            }
        } else {
            LOGGER.debug("Logout operation is not yet attempted for [{}] given logout type is set to [{}]", (Object)selectedService, (Object)type);
            logoutRequest.setStatus(LogoutRequestStatus.NOT_ATTEMPTED);
        }
        return logoutRequest;
    }

    public boolean performBackChannelLogout(LogoutRequest request) {
        try {
            LOGGER.debug("Creating back-channel logout request based on [{}]", (Object)request);
            String logoutRequest = this.logoutMessageBuilder.create(request);
            WebApplicationService logoutService = request.getService();
            logoutService.setLoggedOutAlready(true);
            LOGGER.debug("Preparing logout request for [{}] to [{}]", (Object)logoutService.getId(), (Object)request.getLogoutUrl());
            LogoutHttpMessage msg = new LogoutHttpMessage(request.getLogoutUrl(), logoutRequest, this.asynchronous);
            LOGGER.debug("Prepared logout message to send is [{}]. Sending...", (Object)msg);
            return this.httpClient.sendMessageToEndPoint((HttpMessage)msg);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static boolean serviceSupportsSingleLogout(RegisteredService registeredService) {
        return registeredService != null && registeredService.getAccessStrategy().isServiceAccessAllowed() && registeredService.getLogoutType() != RegisteredService.LogoutType.NONE;
    }

    @Generated
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public LogoutMessageCreator getLogoutMessageBuilder() {
        return this.logoutMessageBuilder;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public SingleLogoutServiceLogoutUrlBuilder getSingleLogoutServiceLogoutUrlBuilder() {
        return this.singleLogoutServiceLogoutUrlBuilder;
    }

    @Generated
    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    @Generated
    public AuthenticationServiceSelectionPlan getAuthenticationRequestServiceSelectionStrategies() {
        return this.authenticationRequestServiceSelectionStrategies;
    }

    @Generated
    public DefaultSingleLogoutServiceMessageHandler(HttpClient httpClient, LogoutMessageCreator logoutMessageBuilder, ServicesManager servicesManager, SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder, boolean asynchronous, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies) {
        this.httpClient = httpClient;
        this.logoutMessageBuilder = logoutMessageBuilder;
        this.servicesManager = servicesManager;
        this.singleLogoutServiceLogoutUrlBuilder = singleLogoutServiceLogoutUrlBuilder;
        this.asynchronous = asynchronous;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
    }
}

