/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.security.PublicKey;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.RegisteredServicePublicKey;
import org.apereo.cas.util.crypto.PublicKeyFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.data.annotation.Transient;

public class RegisteredServicePublicKeyImpl
implements RegisteredServicePublicKey {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServicePublicKeyImpl.class);
    private static final long serialVersionUID = -8497658523695695863L;
    private String location;
    private String algorithm = "RSA";
    @JsonIgnore
    @Transient
    private Class<PublicKeyFactoryBean> publicKeyFactoryBeanClass = PublicKeyFactoryBean.class;

    public RegisteredServicePublicKeyImpl(String location, String algorithm) {
        this.location = location;
        this.algorithm = algorithm;
    }

    public PublicKey createInstance() {
        PublicKeyFactoryBean factory = this.publicKeyFactoryBeanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (this.location.startsWith("classpath:")) {
            factory.setResource((Resource)new ClassPathResource(StringUtils.removeStart((String)this.location, (String)"classpath:")));
        } else {
            factory.setResource((Resource)new FileSystemResource(this.location));
        }
        factory.setAlgorithm(this.algorithm);
        factory.setSingleton(false);
        return (PublicKey)factory.getObject();
    }

    @Generated
    public String toString() {
        return "RegisteredServicePublicKeyImpl(location=" + this.location + ", algorithm=" + this.algorithm + ", publicKeyFactoryBeanClass=" + this.publicKeyFactoryBeanClass + ")";
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public Class<PublicKeyFactoryBean> getPublicKeyFactoryBeanClass() {
        return this.publicKeyFactoryBeanClass;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Generated
    public void setPublicKeyFactoryBeanClass(Class<PublicKeyFactoryBean> publicKeyFactoryBeanClass) {
        this.publicKeyFactoryBeanClass = publicKeyFactoryBeanClass;
    }

    @Generated
    public RegisteredServicePublicKeyImpl() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisteredServicePublicKeyImpl)) {
            return false;
        }
        RegisteredServicePublicKeyImpl other = (RegisteredServicePublicKeyImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$location = this.location;
        String other$location = other.location;
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$algorithm = this.algorithm;
        String other$algorithm = other.algorithm;
        return !(this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegisteredServicePublicKeyImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $location = this.location;
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $algorithm = this.algorithm;
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        return result;
    }
}

