/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.services.RegisteredServiceAttributeFilter;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceRegexAttributeFilter
implements RegisteredServiceAttributeFilter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceRegexAttributeFilter.class);
    private static final long serialVersionUID = 403015306984610128L;
    private Pattern compiledPattern;
    private String pattern;
    private int order;

    public RegisteredServiceRegexAttributeFilter(String regex) {
        this.compiledPattern = Pattern.compile(regex);
        this.pattern = regex;
    }

    public Map<String, Object> filter(Map<String, Object> givenAttributes) {
        HashMap<String, Object> attributesToRelease = new HashMap<String, Object>();
        givenAttributes.entrySet().stream().filter((? super T entry) -> {
            String attributeName = (String)entry.getKey();
            Object attributeValue = entry.getValue();
            LOGGER.debug("Received attribute [{}] with value [{}]", (Object)attributeName, attributeValue);
            return attributeValue != null;
        }).forEach(entry -> {
            String attributeName = (String)entry.getKey();
            Object attributeValue = entry.getValue();
            if (attributeValue instanceof Collection) {
                LOGGER.trace("Attribute value [{}] is a collection", attributeValue);
                List filteredAttributes = this.filterAttributes((Collection)attributeValue, attributeName);
                if (!filteredAttributes.isEmpty()) {
                    attributesToRelease.put(attributeName, filteredAttributes);
                }
            } else if (attributeValue.getClass().isArray()) {
                LOGGER.trace("Attribute value [{}] is an array", attributeValue);
                List filteredAttributes = this.filterAttributes(CollectionUtils.wrapList((Object[])((String[])attributeValue)), attributeName);
                if (!filteredAttributes.isEmpty()) {
                    attributesToRelease.put(attributeName, filteredAttributes);
                }
            } else if (attributeValue instanceof Map) {
                LOGGER.trace("Attribute value [{}] is a map", attributeValue);
                Map<String, String> filteredAttributes = this.filterAttributes((Map)attributeValue);
                if (!filteredAttributes.isEmpty()) {
                    attributesToRelease.put(attributeName, filteredAttributes);
                }
            } else {
                LOGGER.trace("Attribute value [{}] is a string", attributeValue);
                String attrValue = attributeValue.toString();
                if (this.patternMatchesAttributeValue(attrValue)) {
                    this.logReleasedAttributeEntry(attributeName, attrValue);
                    attributesToRelease.put(attributeName, attrValue);
                }
            }
        });
        LOGGER.debug("Received [{}] attributes. Filtered and released [{}]", (Object)givenAttributes.size(), (Object)attributesToRelease.size());
        return attributesToRelease;
    }

    private Map<String, String> filterAttributes(Map<String, String> valuesToFilter) {
        return valuesToFilter.entrySet().stream().filter((? super T entry) -> this.patternMatchesAttributeValue((String)entry.getValue())).map(entry -> {
            this.logReleasedAttributeEntry((String)entry.getKey(), (String)entry.getValue());
            return entry;
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)valuesToFilter.get(entry.getKey()), (e, f) -> f == null ? e : f));
    }

    private List filterAttributes(Collection<String> valuesToFilter, String attributeName) {
        return valuesToFilter.stream().filter(this::patternMatchesAttributeValue).map(attributeValue -> {
            this.logReleasedAttributeEntry(attributeName, (String)attributeValue);
            return attributeValue;
        }).collect(Collectors.toList());
    }

    private boolean patternMatchesAttributeValue(String value) {
        return this.compiledPattern.matcher(value).matches();
    }

    private void logReleasedAttributeEntry(String attributeName, String attributeValue) {
        LOGGER.debug("The attribute value [{}] for attribute name [{}] matches the pattern [{}]. Releasing attribute...", new Object[]{attributeValue, attributeName, this.compiledPattern.pattern()});
    }

    @Generated
    public String toString() {
        return "RegisteredServiceRegexAttributeFilter(compiledPattern=" + this.compiledPattern + ", pattern=" + this.pattern + ", order=" + this.order + ")";
    }

    @Generated
    public void setCompiledPattern(Pattern compiledPattern) {
        this.compiledPattern = compiledPattern;
    }

    @Generated
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public RegisteredServiceRegexAttributeFilter() {
    }

    @Generated
    public Pattern getCompiledPattern() {
        return this.compiledPattern;
    }

    @Generated
    public String getPattern() {
        return this.pattern;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisteredServiceRegexAttributeFilter)) {
            return false;
        }
        RegisteredServiceRegexAttributeFilter other = (RegisteredServiceRegexAttributeFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pattern = this.pattern;
        String other$pattern = other.pattern;
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        return this.order == other.order;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegisteredServiceRegexAttributeFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pattern = this.pattern;
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        result = result * 59 + this.order;
        return result;
    }
}

