/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.support;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.RegisteredServiceAttributeFilter;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceScriptedAttributeFilter
implements RegisteredServiceAttributeFilter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceScriptedAttributeFilter.class);
    private static final long serialVersionUID = 122972056984610198L;
    private int order;
    private String script;

    public Map<String, Object> filter(Map<String, Object> givenAttributes) {
        Matcher matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript((String)this.script);
        Matcher matcherFile = ScriptingUtils.getMatcherForExternalGroovyScript((String)this.script);
        if (matcherInline.find()) {
            return RegisteredServiceScriptedAttributeFilter.filterInlinedGroovyAttributeValues(givenAttributes, matcherInline.group(1));
        }
        if (matcherFile.find()) {
            return RegisteredServiceScriptedAttributeFilter.filterFileBasedGroovyAttributeValues(givenAttributes, matcherFile.group(2));
        }
        return givenAttributes;
    }

    private static Map<String, Object> getGroovyAttributeValue(String groovyScript, Map<String, Object> resolvedAttributes) {
        Map args = CollectionUtils.wrap((String)"attributes", resolvedAttributes, (String)"logger", (Object)LOGGER);
        return (Map)ScriptingUtils.executeGroovyShellScript((String)groovyScript, (Map)args, Map.class);
    }

    private static Map<String, Object> filterInlinedGroovyAttributeValues(Map<String, Object> resolvedAttributes, String script) {
        LOGGER.debug("Found inline groovy script to execute [{}]", (Object)script);
        Map<String, Object> attributesToRelease = RegisteredServiceScriptedAttributeFilter.getGroovyAttributeValue(script, resolvedAttributes);
        return attributesToRelease;
    }

    private static Map<String, Object> filterFileBasedGroovyAttributeValues(Map<String, Object> resolvedAttributes, String scriptFile) {
        try {
            LOGGER.debug("Found groovy script file to execute [{}]", (Object)scriptFile);
            String script = FileUtils.readFileToString((File)new File(scriptFile), (Charset)StandardCharsets.UTF_8);
            Map<String, Object> attributesToRelease = RegisteredServiceScriptedAttributeFilter.getGroovyAttributeValue(script, resolvedAttributes);
            return attributesToRelease;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new HashMap<String, Object>(0);
        }
    }

    @Generated
    public String toString() {
        return "RegisteredServiceScriptedAttributeFilter(order=" + this.order + ", script=" + this.script + ")";
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public String getScript() {
        return this.script;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setScript(String script) {
        this.script = script;
    }

    @Generated
    public RegisteredServiceScriptedAttributeFilter() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisteredServiceScriptedAttributeFilter)) {
            return false;
        }
        RegisteredServiceScriptedAttributeFilter other = (RegisteredServiceScriptedAttributeFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        String this$script = this.script;
        String other$script = other.script;
        return !(this$script == null ? other$script != null : !this$script.equals(other$script));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegisteredServiceScriptedAttributeFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.order;
        String $script = this.script;
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        return result;
    }
}

