/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceExpirationPolicy;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.events.service.CasRegisteredServiceDeletedEvent;
import org.apereo.cas.support.events.service.CasRegisteredServiceExpiredEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicePreDeleteEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicePreSaveEvent;
import org.apereo.cas.support.events.service.CasRegisteredServiceSavedEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicesDeletedEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicesLoadedEvent;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.annotation.Scheduled;

public abstract class AbstractServicesManager
implements ServicesManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServicesManager.class);
    private static final long serialVersionUID = -8581398063126547772L;
    private final ServiceRegistry serviceRegistry;
    private final transient ApplicationEventPublisher eventPublisher;
    private Map<Long, RegisteredService> services = new ConcurrentHashMap<Long, RegisteredService>();

    public AbstractServicesManager(ServiceRegistry serviceRegistry, ApplicationEventPublisher eventPublisher) {
        this.serviceRegistry = serviceRegistry;
        this.eventPublisher = eventPublisher;
    }

    public Collection<RegisteredService> getAllServices() {
        return this.services.values().stream().filter(this.getRegisteredServicesFilteringPredicate(new Predicate[0])).sorted().peek(RegisteredService::initialize).collect(Collectors.toList());
    }

    public Collection<RegisteredService> findServiceBy(Predicate<RegisteredService> predicate) {
        if (predicate == null) {
            return new ArrayList<RegisteredService>(0);
        }
        return this.getAllServices().stream().filter(this.getRegisteredServicesFilteringPredicate(predicate)).sorted().peek(RegisteredService::initialize).collect(Collectors.toList());
    }

    public RegisteredService findServiceBy(String serviceId) {
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            return null;
        }
        RegisteredService service = this.getCandidateServicesToMatch(serviceId).stream().filter(r -> r.matches(serviceId)).findFirst().orElse(null);
        if (service != null) {
            service.initialize();
        }
        RegisteredService result = this.validateRegisteredService(service);
        return result;
    }

    public RegisteredService findServiceBy(Service service) {
        return service != null ? this.findServiceBy(service.getId()) : null;
    }

    public <T extends RegisteredService> T findServiceBy(String serviceId, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            return null;
        }
        RegisteredService service = this.findServiceBy(serviceId);
        if (service != null && service.getClass().equals(clazz)) {
            return (T)service;
        }
        return null;
    }

    public <T extends RegisteredService> T findServiceBy(Service serviceId, Class<T> clazz) {
        return this.findServiceBy(serviceId.getId(), clazz);
    }

    public RegisteredService findServiceBy(long id) {
        return this.services.get(id);
    }

    public int count() {
        return this.services.size();
    }

    public boolean matchesExistingService(Service service) {
        return this.matchesExistingService(service.getId());
    }

    public boolean matchesExistingService(String service) {
        return this.findServiceBy(service) != null;
    }

    @Audit(action="DELETE_SERVICE", actionResolverName="DELETE_SERVICE_ACTION_RESOLVER", resourceResolverName="DELETE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService delete(long id) {
        RegisteredService service = this.findServiceBy(id);
        return this.delete(service);
    }

    @Audit(action="DELETE_SERVICE", actionResolverName="DELETE_SERVICE_ACTION_RESOLVER", resourceResolverName="DELETE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService delete(RegisteredService service) {
        if (service != null) {
            this.publishEvent((ApplicationEvent)new CasRegisteredServicePreDeleteEvent((Object)this, service));
            this.serviceRegistry.delete(service);
            this.services.remove(service.getId());
            this.deleteInternal(service);
            this.publishEvent((ApplicationEvent)new CasRegisteredServiceDeletedEvent((Object)this, service));
        }
        return service;
    }

    @Audit(action="SAVE_SERVICE", actionResolverName="SAVE_SERVICE_ACTION_RESOLVER", resourceResolverName="SAVE_SERVICE_RESOURCE_RESOLVER")
    public RegisteredService save(RegisteredService registeredService) {
        return this.save(registeredService, true);
    }

    @Audit(action="SAVE_SERVICE", actionResolverName="SAVE_SERVICE_ACTION_RESOLVER", resourceResolverName="SAVE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService save(RegisteredService registeredService, boolean publishEvent) {
        this.publishEvent((ApplicationEvent)new CasRegisteredServicePreSaveEvent((Object)this, registeredService));
        RegisteredService r = this.serviceRegistry.save(registeredService);
        this.services.put(r.getId(), r);
        this.saveInternal(registeredService);
        if (publishEvent) {
            this.publishEvent((ApplicationEvent)new CasRegisteredServiceSavedEvent((Object)this, r));
        }
        return r;
    }

    @Scheduled(initialDelayString="${cas.serviceRegistry.schedule.startDelay:20000}", fixedDelayString="${cas.serviceRegistry.schedule.repeatInterval:60000}")
    @PostConstruct
    public Collection<RegisteredService> load() {
        LOGGER.debug("Loading services from [{}]", (Object)this.serviceRegistry);
        this.services = this.serviceRegistry.load().stream().collect(Collectors.toConcurrentMap(r -> {
            LOGGER.debug("Adding registered service [{}]", (Object)r.getServiceId());
            return r.getId();
        }, Function.identity(), (r, s) -> s == null ? r : s));
        this.loadInternal();
        this.publishEvent((ApplicationEvent)new CasRegisteredServicesLoadedEvent((Object)this, this.getAllServices()));
        this.evaluateExpiredServiceDefinitions();
        LOGGER.info("Loaded [{}] service(s) from [{}].", (Object)this.services.size(), (Object)this.serviceRegistry.getName());
        return this.services.values();
    }

    public synchronized void deleteAll() {
        this.services.forEach((k, v) -> this.delete((RegisteredService)v));
        this.services.clear();
        this.publishEvent((ApplicationEvent)new CasRegisteredServicesDeletedEvent((Object)this));
    }

    private void evaluateExpiredServiceDefinitions() {
        this.services.values().stream().filter(this.getRegisteredServicesFilteringPredicate(new Predicate[0]).negate()).filter(Objects::nonNull).forEach(this::processExpiredRegisteredService);
    }

    private Predicate<RegisteredService> getRegisteredServicesFilteringPredicate(Predicate<RegisteredService> ... p) {
        ArrayList<Predicate<RegisteredService>> predicates = new ArrayList<Predicate<RegisteredService>>();
        Predicate<RegisteredService> expirationPolicyPredicate = this.getRegisteredServiceExpirationPolicyPredicate();
        predicates.add(expirationPolicyPredicate);
        predicates.addAll(Stream.of(p).collect(Collectors.toList()));
        return predicates.stream().reduce(x -> true, Predicate::and);
    }

    private Predicate<RegisteredService> getRegisteredServiceExpirationPolicyPredicate() {
        return service -> {
            try {
                if (service == null) {
                    return false;
                }
                RegisteredServiceExpirationPolicy policy = service.getExpirationPolicy();
                if (policy == null || StringUtils.isBlank((CharSequence)policy.getExpirationDate())) {
                    return true;
                }
                LocalDateTime now = this.getCurrentSystemTime();
                LocalDateTime expirationDate = DateTimeUtils.localDateTimeOf((String)policy.getExpirationDate());
                LOGGER.debug("Service expiration date is [{}] while now is [{}]", (Object)expirationDate, (Object)now);
                return !now.isAfter(expirationDate);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                return false;
            }
        };
    }

    protected LocalDateTime getCurrentSystemTime() {
        return LocalDateTime.now();
    }

    private RegisteredService validateRegisteredService(RegisteredService registeredService) {
        RegisteredService result = this.checkServiceExpirationPolicyIfAny(registeredService);
        return result;
    }

    private RegisteredService checkServiceExpirationPolicyIfAny(RegisteredService registeredService) {
        if (registeredService == null || this.getRegisteredServiceExpirationPolicyPredicate().test(registeredService)) {
            return registeredService;
        }
        return this.processExpiredRegisteredService(registeredService);
    }

    private RegisteredService processExpiredRegisteredService(RegisteredService registeredService) {
        RegisteredServiceExpirationPolicy policy = registeredService.getExpirationPolicy();
        LOGGER.warn("Registered service [{}] has expired on [{}]", (Object)registeredService.getServiceId(), (Object)policy.getExpirationDate());
        if (policy.isDeleteWhenExpired()) {
            LOGGER.debug("Deleting expired registered service [{}] from registry.", (Object)registeredService.getServiceId());
            if (policy.isNotifyWhenDeleted()) {
                LOGGER.debug("Contacts for registered service [{}] will be notified of service expiry", (Object)registeredService.getServiceId());
                this.publishEvent((ApplicationEvent)new CasRegisteredServiceExpiredEvent((Object)this, registeredService));
            }
            this.delete(registeredService);
            return null;
        }
        LOGGER.debug("Disabling expired registered service [{}].", (Object)registeredService.getServiceId());
        registeredService.getAccessStrategy().setServiceAccessAllowed(false);
        return this.save(registeredService);
    }

    protected abstract Collection<RegisteredService> getCandidateServicesToMatch(String var1);

    protected void deleteInternal(RegisteredService service) {
    }

    protected void saveInternal(RegisteredService service) {
    }

    protected void loadInternal() {
    }

    private void publishEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }
}

