/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.events.service.CasRegisteredServiceLoadedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class InMemoryServiceRegistry
extends AbstractServiceRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryServiceRegistry.class);
    private List<RegisteredService> registeredServices = new ArrayList<RegisteredService>();

    public boolean delete(RegisteredService registeredService) {
        return this.registeredServices.remove(registeredService);
    }

    public RegisteredService findServiceById(long id) {
        return this.registeredServices.stream().filter(r -> r.getId() == id).findFirst().orElse(null);
    }

    public RegisteredService findServiceById(String id) {
        return this.registeredServices.stream().filter(r -> r.matches(id)).findFirst().orElse(null);
    }

    public List<RegisteredService> load() {
        ArrayList<RegisteredService> services = new ArrayList<RegisteredService>();
        this.registeredServices.forEach(s -> {
            this.publishEvent((ApplicationEvent)new CasRegisteredServiceLoadedEvent((Object)this, s));
            services.add((RegisteredService)s);
        });
        return services;
    }

    public RegisteredService save(RegisteredService registeredService) {
        RegisteredService svc;
        if (registeredService.getId() == -1L) {
            registeredService.setId(this.findHighestId() + 1L);
        }
        if ((svc = this.findServiceById(registeredService.getId())) != null) {
            this.registeredServices.remove(svc);
        }
        this.registeredServices.add(registeredService);
        return registeredService;
    }

    private long findHighestId() {
        return this.registeredServices.stream().map(RegisteredService::getId).max(Comparator.naturalOrder()).orElse(0L);
    }

    public long size() {
        return this.registeredServices.size();
    }

    @Generated
    public String toString() {
        return "InMemoryServiceRegistry(registeredServices=" + this.registeredServices + ")";
    }

    @Generated
    public void setRegisteredServices(List<RegisteredService> registeredServices) {
        this.registeredServices = registeredServices;
    }

    @Generated
    public InMemoryServiceRegistry() {
    }

    @Generated
    public InMemoryServiceRegistry(List<RegisteredService> registeredServices) {
        this.registeredServices = registeredServices;
    }
}

