/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.factory;

import java.io.Serializable;
import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTicketGrantingTicketFactory
implements TicketGrantingTicketFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTicketGrantingTicketFactory.class);
    protected UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator;
    protected ExpirationPolicy ticketGrantingTicketExpirationPolicy;
    protected CipherExecutor<Serializable, String> cipherExecutor;

    public <T extends TicketGrantingTicket> T create(Authentication authentication, Class<T> clazz) {
        String tgtId = this.produceTicketIdentifier(authentication);
        return this.produceTicket(authentication, tgtId, clazz);
    }

    public TicketFactory get(Class<? extends Ticket> clazz) {
        return this;
    }

    protected <T extends TicketGrantingTicket> T produceTicket(Authentication authentication, String tgtId, Class<T> clazz) {
        TicketGrantingTicketImpl result = new TicketGrantingTicketImpl(tgtId, authentication, this.ticketGrantingTicketExpirationPolicy);
        if (!clazz.isAssignableFrom(result.getClass())) {
            throw new ClassCastException("Result [" + result + " is of type " + result.getClass() + " when we were expecting " + clazz);
        }
        return (T)result;
    }

    protected String produceTicketIdentifier(Authentication authentication) {
        String tgtId = this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("TGT");
        if (this.cipherExecutor != null) {
            LOGGER.debug("Attempting to encode ticket-granting ticket [{}]", (Object)tgtId);
            tgtId = (String)this.cipherExecutor.encode((Object)tgtId);
            LOGGER.debug("Encoded ticket-granting ticket id [{}]", (Object)tgtId);
        }
        return tgtId;
    }

    @Generated
    public DefaultTicketGrantingTicketFactory(UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator, ExpirationPolicy ticketGrantingTicketExpirationPolicy, CipherExecutor<Serializable, String> cipherExecutor) {
        this.ticketGrantingTicketUniqueTicketIdGenerator = ticketGrantingTicketUniqueTicketIdGenerator;
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
        this.cipherExecutor = cipherExecutor;
    }
}

