/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.support;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.support.BaseDelegatingExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class RememberMeDelegatingExpirationPolicy
extends BaseDelegatingExpirationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RememberMeDelegatingExpirationPolicy.class);
    private static final long serialVersionUID = -2735975347698196127L;

    @JsonCreator
    public RememberMeDelegatingExpirationPolicy(@JsonProperty(value="policy") ExpirationPolicy policy) {
        super(policy);
    }

    @Override
    protected String getExpirationPolicyNameFor(TicketState ticketState) {
        Map attrs = ticketState.getAuthentication().getAttributes();
        Collection c = (Collection)attrs.get("org.apereo.cas.authentication.principal.REMEMBER_ME");
        if (c == null || c.contains(Boolean.FALSE)) {
            LOGGER.debug("Ticket is not associated with a remember-me authentication.");
            return PolicyTypes.DEFAULT.name();
        }
        return PolicyTypes.REMEMBER_ME.name();
    }

    public static enum PolicyTypes {
        REMEMBER_ME,
        DEFAULT;

    }
}

