/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.support;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.support.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class ThrottledUseAndTimeoutExpirationPolicy
extends AbstractCasExpirationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ThrottledUseAndTimeoutExpirationPolicy.class);
    private static final long serialVersionUID = 205979491183779408L;
    private long timeToKillInSeconds;
    private long timeInBetweenUsesInSeconds;

    @JsonCreator
    public ThrottledUseAndTimeoutExpirationPolicy(@JsonProperty(value="timeToLive") long timeToKillInSeconds, @JsonProperty(value="timeToIdle") long timeInBetweenUsesInSeconds) {
        this.timeToKillInSeconds = timeToKillInSeconds;
        this.timeInBetweenUsesInSeconds = timeInBetweenUsesInSeconds;
    }

    @Override
    public boolean isExpired(TicketState ticketState) {
        ZonedDateTime currentTime = ZonedDateTime.now(ZoneOffset.UTC);
        ZonedDateTime lastTimeUsed = ticketState.getLastTimeUsed();
        ZonedDateTime killTime = lastTimeUsed.plus(this.timeToKillInSeconds, ChronoUnit.SECONDS);
        if (ticketState.getCountOfUses() == 0 && currentTime.isBefore(killTime)) {
            LOGGER.debug("Ticket is not expired due to a count of zero and the time being less than the timeToKillInSeconds");
            return super.isExpired(ticketState);
        }
        if (currentTime.isAfter(killTime)) {
            LOGGER.debug("Ticket is expired due to the time being greater than the timeToKillInSeconds");
            return true;
        }
        ZonedDateTime dontUseUntil = lastTimeUsed.plus(this.timeInBetweenUsesInSeconds, ChronoUnit.SECONDS);
        if (currentTime.isBefore(dontUseUntil)) {
            LOGGER.warn("Ticket is expired due to the time being less than the waiting period.");
            return true;
        }
        return super.isExpired(ticketState);
    }

    public Long getTimeToLive() {
        return this.timeToKillInSeconds;
    }

    public Long getTimeToIdle() {
        return this.timeInBetweenUsesInSeconds;
    }

    @Generated
    public void setTimeToKillInSeconds(long timeToKillInSeconds) {
        this.timeToKillInSeconds = timeToKillInSeconds;
    }

    @Generated
    public void setTimeInBetweenUsesInSeconds(long timeInBetweenUsesInSeconds) {
        this.timeInBetweenUsesInSeconds = timeInBetweenUsesInSeconds;
    }

    @Generated
    public ThrottledUseAndTimeoutExpirationPolicy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThrottledUseAndTimeoutExpirationPolicy)) {
            return false;
        }
        ThrottledUseAndTimeoutExpirationPolicy other = (ThrottledUseAndTimeoutExpirationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.timeToKillInSeconds != other.timeToKillInSeconds) {
            return false;
        }
        return this.timeInBetweenUsesInSeconds == other.timeInBetweenUsesInSeconds;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ThrottledUseAndTimeoutExpirationPolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $timeToKillInSeconds = this.timeToKillInSeconds;
        result = result * 59 + (int)($timeToKillInSeconds >>> 32 ^ $timeToKillInSeconds);
        long $timeInBetweenUsesInSeconds = this.timeInBetweenUsesInSeconds;
        result = result * 59 + (int)($timeInBetweenUsesInSeconds >>> 32 ^ $timeInBetweenUsesInSeconds);
        return result;
    }
}

