/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.apereo.cas.util.InetAddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostNameBasedUniqueTicketIdGenerator
extends DefaultUniqueTicketIdGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HostNameBasedUniqueTicketIdGenerator.class);

    public HostNameBasedUniqueTicketIdGenerator(int maxLength, String suffix) {
        super(maxLength, HostNameBasedUniqueTicketIdGenerator.determineTicketSuffixByHostName(suffix));
    }

    private static String determineTicketSuffixByHostName(String suffix) {
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            return suffix;
        }
        return InetAddressUtils.getCasServerHostName();
    }

    public static class ProxyTicketIdGenerator
    extends HostNameBasedUniqueTicketIdGenerator {
        public ProxyTicketIdGenerator(int maxLength, String suffix) {
            super(maxLength, suffix);
        }
    }

    public static class ServiceTicketIdGenerator
    extends HostNameBasedUniqueTicketIdGenerator {
        public ServiceTicketIdGenerator(int maxLength, String suffix) {
            super(maxLength, suffix);
        }
    }

    public static class TicketGrantingTicketIdGenerator
    extends HostNameBasedUniqueTicketIdGenerator {
        public TicketGrantingTicketIdGenerator(int maxLength, String suffix) {
            super(maxLength, suffix);
        }
    }
}

