/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.io.File;
import java.net.URL;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apereo.cas.util.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.VfsResource;

public final class CasVersion {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasVersion.class);

    public static String getVersion() {
        return CasVersion.class.getPackage().getImplementationVersion();
    }

    public static String getSpecificationVersion() {
        return CasVersion.class.getPackage().getSpecificationVersion();
    }

    public static ZonedDateTime getDateTime() {
        Class<CasVersion> clazz = CasVersion.class;
        URL resource = clazz.getResource(clazz.getSimpleName() + ".class");
        if ("file".equals(resource.getProtocol())) {
            return DateTimeUtils.zonedDateTimeOf(new File(resource.toURI()).lastModified());
        }
        if ("jar".equals(resource.getProtocol())) {
            String path = resource.getPath();
            File file = new File(path.substring(5, path.indexOf(33)));
            return DateTimeUtils.zonedDateTimeOf(file.lastModified());
        }
        if ("vfs".equals(resource.getProtocol())) {
            File file = new VfsResource(resource.openConnection().getContent()).getFile();
            return DateTimeUtils.zonedDateTimeOf(file.lastModified());
        }
        LOGGER.warn("Unhandled url protocol: [{}] resource: [{}]", (Object)resource.getProtocol(), (Object)resource);
        return ZonedDateTime.now();
    }

    @Generated
    private CasVersion() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

