/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectionUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionUtils.class);

    public static Optional<Object> firstElement(Object obj) {
        Set<Object> object = CollectionUtils.toCollection(obj);
        if (object.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(object.iterator().next());
    }

    public static <T extends Collection> T toCollection(Object obj, Class<T> clazz) {
        Set<Object> results = CollectionUtils.toCollection(obj);
        Collection col = (Collection)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        col.addAll(results);
        return (T)col;
    }

    public static Set<Object> toCollection(Object obj) {
        LinkedHashSet<Object> c = new LinkedHashSet<Object>();
        if (obj == null) {
            LOGGER.debug("Converting null obj to empty collection");
        } else if (obj instanceof Collection) {
            c.addAll((Collection)obj);
            LOGGER.trace("Converting multi-valued attribute [{}]", obj);
        } else if (obj instanceof Map) {
            Set set = ((Map)obj).entrySet();
            c.addAll(set.stream().map(e -> Pair.of(e.getKey(), e.getValue())).collect(Collectors.toSet()));
        } else if (obj.getClass().isArray()) {
            c.addAll(Arrays.stream((Object[])obj).collect(Collectors.toSet()));
            LOGGER.trace("Converting array attribute [{}]", obj);
        } else {
            c.add(obj);
            LOGGER.trace("Converting attribute [{}]", obj);
        }
        return c;
    }

    public static <K, V> Map<K, V> wrap(Multimap<K, V> source) {
        if (source != null && !source.isEmpty()) {
            Map inner = source.asMap();
            HashMap map = new HashMap();
            inner.forEach((k, v) -> map.put(k, CollectionUtils.wrap(v)));
            return map;
        }
        return new HashMap(0);
    }

    public static <K, V> Map<K, V> wrap(Map<K, V> source) {
        if (source != null && !source.isEmpty()) {
            return new HashMap<K, V>(source);
        }
        return new HashMap(0);
    }

    public static <K, V> Map<K, V> wrap(String key, Object value) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (value != null && StringUtils.isNotBlank((CharSequence)key)) {
            map.put(key, value);
        }
        return map;
    }

    public static <K extends String, V> Map<K, V> wrap(String key, Object value, String key2, Object value2) {
        Map<String, Object> m = CollectionUtils.wrap(key, value);
        m.put(key2, value2);
        return m;
    }

    public static <K, V> Map<K, V> wrap(String key, Object value, String key2, Object value2, String key3, Object value3) {
        Map<String, Object> m = CollectionUtils.wrap(key, value, key2, value2);
        m.put(key3, value3);
        return m;
    }

    public static <K, V> Map<K, V> wrap(String key, Object value, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Map<String, Object> m = CollectionUtils.wrap(key, value, key2, value2, key3, value3);
        m.put(key4, value4);
        return m;
    }

    public static <K, V> Map<K, V> wrap(String key, Object value, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        Map<String, Object> m = CollectionUtils.wrap(key, value, key2, value2, key3, value3, key4, value4);
        m.put(key5, value5);
        return m;
    }

    public static <K, V> Map<K, V> wrap(String key, Object value, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6) {
        Map<String, Object> m = CollectionUtils.wrap(key, value, key2, value2, key3, value3, key4, value4, key5, value5);
        m.put(key6, value6);
        return m;
    }

    public static <K, V> Map<K, V> wrap(String key, Object value, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7) {
        Map<String, Object> m = CollectionUtils.wrap(key, value, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6);
        m.put(key7, value7);
        return m;
    }

    public static <T> List<T> wrap(T source) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (source != null) {
            if (source instanceof Collection) {
                Iterator it = ((Collection)source).iterator();
                while (it.hasNext()) {
                    list.add(it.next());
                }
            } else if (source.getClass().isArray()) {
                List elements = Arrays.stream((Object[])source).collect(Collectors.toList());
                list.addAll(elements);
            } else {
                list.add(source);
            }
        }
        return list;
    }

    public static <T> List<T> wrap(List<T> source) {
        ArrayList<T> list = new ArrayList<T>();
        if (source != null && !source.isEmpty()) {
            list.addAll(source);
        }
        return list;
    }

    public static <T> Set<T> wrap(Set<T> source) {
        LinkedHashSet<T> list = new LinkedHashSet<T>();
        if (source != null && !source.isEmpty()) {
            list.addAll(source);
        }
        return list;
    }

    public static <T> Set<T> wrapSet(T source) {
        LinkedHashSet<T> list = new LinkedHashSet<T>();
        if (source != null) {
            list.add(source);
        }
        return list;
    }

    public static <T> Set<T> wrapSet(T ... source) {
        LinkedHashSet list = new LinkedHashSet();
        CollectionUtils.addToCollection(list, source);
        return list;
    }

    public static <T> HashSet<T> wrapHashSet(T ... source) {
        HashSet list = new HashSet();
        CollectionUtils.addToCollection(list, source);
        return list;
    }

    public static <T> List<T> wrapList(T ... source) {
        ArrayList list = new ArrayList();
        CollectionUtils.addToCollection(list, source);
        return list;
    }

    private static <T> void addToCollection(Collection<T> list, T[] source) {
        if (source != null) {
            Arrays.stream(source).forEach(s -> {
                Set<Object> col = CollectionUtils.toCollection(s);
                list.addAll(col);
            });
        }
    }

    @Generated
    private CollectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

