/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompressionUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressionUtils.class);
    private static final int INFLATED_ARRAY_LENGTH = 10000;

    public static String deflate(byte[] bytes) {
        String data = new String(bytes, StandardCharsets.UTF_8);
        return CompressionUtils.deflate(data);
    }

    public static String deflate(String data) {
        Deflater deflater = new Deflater();
        deflater.setInput(data.getBytes(StandardCharsets.UTF_8));
        deflater.finish();
        byte[] buffer = new byte[data.length()];
        int resultSize = deflater.deflate(buffer);
        byte[] output = new byte[resultSize];
        System.arraycopy(buffer, 0, output, 0, resultSize);
        return EncodingUtils.encodeBase64(output);
    }

    public static String inflate(byte[] bytes) {
        Inflater inflater = new Inflater(true);
        byte[] xmlMessageBytes = new byte[10000];
        byte[] extendedBytes = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, extendedBytes, 0, bytes.length);
        extendedBytes[bytes.length] = 0;
        inflater.setInput(extendedBytes);
        try {
            int resultLength = inflater.inflate(xmlMessageBytes);
            inflater.end();
            if (!inflater.finished()) {
                throw new RuntimeException("buffer not large enough.");
            }
            inflater.end();
            return new String(xmlMessageBytes, 0, resultLength, StandardCharsets.UTF_8);
        }
        catch (DataFormatException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(String zippedBase64Str) {
        String string;
        block6: {
            byte[] bytes = EncodingUtils.decodeBase64(zippedBase64Str);
            GZIPInputStream zi = new GZIPInputStream(new ByteArrayInputStream(bytes));
            try {
                string = IOUtils.toString((InputStream)zi, (Charset)Charset.defaultCharset());
                if (Collections.singletonList(zi).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(zi).get(0) != null) {
                    zi.close();
                }
                throw throwable;
            }
            zi.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static String compress(String srcTxt) {
        ByteArrayOutputStream rstBao = new ByteArrayOutputStream();
        try {
            String string;
            block10: {
                GZIPOutputStream zos = new GZIPOutputStream(rstBao);
                try {
                    zos.write(srcTxt.getBytes(StandardCharsets.UTF_8));
                    zos.flush();
                    zos.finish();
                    byte[] bytes = rstBao.toByteArray();
                    String base64 = StringUtils.remove((String)EncodingUtils.encodeBase64(bytes), (char)'\u0000');
                    string = new String(StandardCharsets.UTF_8.encode(base64).array(), StandardCharsets.UTF_8);
                    if (Collections.singletonList(zos).get(0) == null) break block10;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(zos).get(0) != null) {
                        zos.close();
                    }
                    throw throwable;
                }
                zos.close();
            }
            return string;
        }
        finally {
            if (Collections.singletonList(rstBao).get(0) != null) {
                rstBao.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String decodeByteArrayToString(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[bytes.length];
        try (InflaterInputStream iis = new InflaterInputStream(bais);){
            int count = iis.read(buf);
            while (count != -1) {
                baos.write(buf, 0, count);
                count = iis.read(buf);
            }
            String string = new String(baos.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Base64 decoding failed", (Throwable)e);
            return null;
        }
    }

    @Generated
    private CompressionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

