/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.net.InetAddress;
import java.net.URL;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InetAddressUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InetAddressUtils.class);

    public static InetAddress getByName(String urlAddr) {
        try {
            URL url = new URL(urlAddr);
            return InetAddress.getByName(url.getHost());
        }
        catch (Exception e) {
            LOGGER.trace("Host name could not be determined automatically.", (Throwable)e);
            return null;
        }
    }

    public static String getCasServerHostName() {
        String hostName = InetAddress.getLocalHost().getHostName();
        int index = hostName.indexOf(46);
        if (index > 0) {
            return hostName.substring(0, index);
        }
        return hostName;
    }

    public static String getCasServerHostAddress(String name) {
        InetAddress host = InetAddressUtils.getByName(name);
        if (host != null) {
            return host.getHostAddress();
        }
        return null;
    }

    @Generated
    private InetAddressUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

