/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.cipher;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.PrivateKeyFactoryBean;
import org.apereo.cas.util.crypto.PublicKeyFactoryBean;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jose4j.keys.AesKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public abstract class AbstractCipherExecutor<T, R>
implements CipherExecutor<T, R> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCipherExecutor.class);
    private Key signingKey;

    protected byte[] sign(byte[] value) {
        if (this.signingKey == null) {
            return value;
        }
        if ("RSA".equalsIgnoreCase(this.signingKey.getAlgorithm())) {
            return EncodingUtils.signJwsRSASha512(this.signingKey, value);
        }
        return EncodingUtils.signJwsHMACSha512(this.signingKey, value);
    }

    protected void configureSigningKey(String signingSecretKey) {
        try {
            if (ResourceUtils.doesResourceExist(signingSecretKey)) {
                this.configureSigningKeyFromPrivateKeyResource(signingSecretKey);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.signingKey == null) {
                this.setSigningKey((Key)new AesKey(signingSecretKey.getBytes(StandardCharsets.UTF_8)));
                LOGGER.debug("Created signing key instance [{}] based on provided secret key", (Object)this.signingKey.getClass().getSimpleName());
            }
        }
    }

    protected void configureSigningKeyFromPrivateKeyResource(String signingSecretKey) throws Exception {
        PrivateKey object = AbstractCipherExecutor.extractPrivateKeyFromResource(signingSecretKey);
        LOGGER.debug("Located signing key resource [{}]", (Object)signingSecretKey);
        this.setSigningKey(object);
    }

    protected byte[] verifySignature(byte[] value) {
        if (this.signingKey == null) {
            return value;
        }
        return EncodingUtils.verifyJwsSignature(this.signingKey, value);
    }

    public boolean isEnabled() {
        return this.signingKey != null;
    }

    public static PrivateKey extractPrivateKeyFromResource(String signingSecretKey) {
        LOGGER.debug("Attempting to extract private key...");
        AbstractResource resource = ResourceUtils.getResourceFrom(signingSecretKey);
        PrivateKeyFactoryBean factory = new PrivateKeyFactoryBean();
        factory.setAlgorithm("RSA");
        factory.setLocation((Resource)resource);
        factory.setSingleton(false);
        return (PrivateKey)factory.getObject();
    }

    public static PublicKey extractPublicKeyFromResource(String secretKeyToUse) {
        LOGGER.debug("Attempting to extract public key from [{}]...", (Object)secretKeyToUse);
        AbstractResource resource = ResourceUtils.getResourceFrom(secretKeyToUse);
        PublicKeyFactoryBean factory = new PublicKeyFactoryBean();
        factory.setAlgorithm("RSA");
        factory.setResource((Resource)resource);
        factory.setSingleton(false);
        return (PublicKey)factory.getObject();
    }

    @Generated
    public void setSigningKey(Key signingKey) {
        this.signingKey = signingKey;
    }

    @Generated
    public AbstractCipherExecutor() {
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

