/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.cipher;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.cipher.AbstractCipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64CipherExecutor
extends AbstractCipherExecutor<Serializable, String> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Base64CipherExecutor.class);
    private static CipherExecutor<Serializable, String> INSTANCE;

    public static CipherExecutor<Serializable, String> getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Base64CipherExecutor();
        }
        return INSTANCE;
    }

    public String encode(Serializable value, Object[] parameters) {
        return EncodingUtils.encodeBase64(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    public String decode(Serializable value, Object[] parameters) {
        byte[] decoded = EncodingUtils.decodeBase64(value.toString());
        return new String(decoded, StandardCharsets.UTF_8);
    }

    @Generated
    public Base64CipherExecutor() {
    }
}

