/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.crypto;

import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;

public class PublicKeyFactoryBean
extends AbstractFactoryBean<PublicKey> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicKeyFactoryBean.class);
    private Resource resource;
    private String algorithm;

    protected PublicKey createInstance() throws Exception {
        LOGGER.debug("Creating public key instance from [{}] using [{}]", (Object)this.resource.getFilename(), (Object)this.algorithm);
        try (InputStream pubKey = this.resource.getInputStream();){
            byte[] bytes = new byte[(int)this.resource.contentLength()];
            pubKey.read(bytes);
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(this.algorithm);
            PublicKey publicKey = factory.generatePublic(pubSpec);
            return publicKey;
        }
    }

    public Class getObjectType() {
        return PublicKey.class;
    }

    @Generated
    public String toString() {
        return "PublicKeyFactoryBean(super=" + super.toString() + ", resource=" + this.resource + ", algorithm=" + this.algorithm + ")";
    }

    @Generated
    public Resource getResource() {
        return this.resource;
    }

    @Generated
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Generated
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }
}

