/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.gen;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import lombok.Generated;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRandomStringGenerator
implements RandomStringGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRandomStringGenerator.class);
    protected final SecureRandom randomizer = RandomUtils.getNativeInstance();
    protected final int defaultLength;

    public AbstractRandomStringGenerator() {
        this.defaultLength = 36;
    }

    public AbstractRandomStringGenerator(int defaultLength) {
        this.defaultLength = defaultLength;
    }

    @Override
    public String getAlgorithm() {
        return this.randomizer.getAlgorithm();
    }

    protected String convertBytesToString(byte[] random) {
        return new String(random, StandardCharsets.UTF_8);
    }

    @Override
    public String getNewString(int size) {
        byte[] random = this.getNewStringAsBytes(size);
        return this.convertBytesToString(random);
    }

    @Override
    public String getNewString() {
        return this.getNewString(this.getDefaultLength());
    }

    @Override
    public byte[] getNewStringAsBytes(int size) {
        byte[] random = new byte[size];
        this.randomizer.nextBytes(random);
        return random;
    }

    @Override
    public byte[] getNewStringAsBytes() {
        return this.getNewStringAsBytes(this.getDefaultLength());
    }

    @Generated
    public SecureRandom getRandomizer() {
        return this.randomizer;
    }

    @Override
    @Generated
    public int getDefaultLength() {
        return this.defaultLength;
    }
}

