/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.http;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpRequestFutureTask;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.HttpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class SimpleHttpClient
implements HttpClient,
Serializable,
DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHttpClient.class);
    private static final long serialVersionUID = -4949380008568071855L;
    private final List<Integer> acceptableCodes;
    private final transient CloseableHttpClient wrappedHttpClient;
    private final FutureRequestExecutionService requestExecutorService;

    @Override
    public boolean sendMessageToEndPoint(HttpMessage message) {
        try {
            HttpPost request = new HttpPost(message.getUrl().toURI());
            request.addHeader("Content-Type", message.getContentType());
            StringEntity entity = new StringEntity(message.getMessage(), ContentType.create((String)message.getContentType()));
            request.setEntity((HttpEntity)entity);
            ResponseHandler handler = response -> response.getStatusLine().getStatusCode() == 200;
            LOGGER.debug("Created HTTP post message payload [{}]", (Object)request);
            HttpRequestFutureTask task = this.requestExecutorService.execute((HttpUriRequest)request, (HttpContext)HttpClientContext.create(), handler);
            if (message.isAsynchronous()) {
                return true;
            }
            return (Boolean)task.get();
        }
        catch (RejectedExecutionException e) {
            LOGGER.warn("Execution rejected", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.debug("Unable to send message", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpMessage sendMessageToEndPoint(URL url) {
        HttpEntity entity = null;
        try (CloseableHttpResponse response = this.wrappedHttpClient.execute((HttpUriRequest)new HttpGet(url.toURI()));){
            int responseCode = response.getStatusLine().getStatusCode();
            for (int acceptableCode : this.acceptableCodes) {
                if (responseCode != acceptableCode) continue;
                LOGGER.debug("Response code received from server matched [{}].", (Object)responseCode);
                entity = response.getEntity();
                HttpMessage msg = new HttpMessage(url, IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8));
                msg.setContentType(entity.getContentType().getValue());
                msg.setResponseCode(responseCode);
                HttpMessage httpMessage = msg;
                EntityUtils.consumeQuietly((HttpEntity)entity);
                return httpMessage;
            }
            LOGGER.warn("Response code [{}] from [{}] did not match any of the acceptable response codes.", (Object)responseCode, (Object)url);
            if (responseCode == 500) {
                String value = response.getStatusLine().getReasonPhrase();
                LOGGER.error("There was an error contacting the endpoint: [{}]; The error:\n[{}]", (Object)url.toExternalForm(), (Object)value);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to send message", (Throwable)e);
        }
        finally {
            EntityUtils.consumeQuietly(entity);
        }
        return null;
    }

    @Override
    public boolean isValidEndPoint(String url) {
        try {
            URL u = new URL(url);
            return this.isValidEndPoint(u);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Unable to build URL", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidEndPoint(URL url) {
        HttpEntity entity = null;
        try {
            try (CloseableHttpResponse response = this.wrappedHttpClient.execute((HttpUriRequest)new HttpGet(url.toURI()));){
                int responseCode = response.getStatusLine().getStatusCode();
                int idx = Collections.binarySearch(this.acceptableCodes, responseCode);
                if (idx >= 0) {
                    LOGGER.debug("Response code from server matched [{}].", (Object)responseCode);
                    boolean bl = true;
                    return bl;
                }
                LOGGER.debug("Response code did not match any of the acceptable response codes. Code returned was [{}]", (Object)responseCode);
                if (responseCode == 500) {
                    String value = response.getStatusLine().getReasonPhrase();
                    LOGGER.error("There was an error contacting the endpoint: [{}]; The error was:\n[{}]", (Object)url.toExternalForm(), (Object)value);
                }
                entity = response.getEntity();
            }
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            EntityUtils.consumeQuietly(entity);
        }
        return false;
    }

    public void destroy() {
        IOUtils.closeQuietly((Closeable)this.requestExecutorService);
    }

    @Generated
    public List<Integer> getAcceptableCodes() {
        return this.acceptableCodes;
    }

    @Generated
    public CloseableHttpClient getWrappedHttpClient() {
        return this.wrappedHttpClient;
    }

    @Generated
    public FutureRequestExecutionService getRequestExecutorService() {
        return this.requestExecutorService;
    }

    @Generated
    public SimpleHttpClient(List<Integer> acceptableCodes, CloseableHttpClient wrappedHttpClient, FutureRequestExecutionService requestExecutorService) {
        this.acceptableCodes = acceptableCodes;
        this.wrappedHttpClient = wrappedHttpClient;
        this.requestExecutorService = requestExecutorService;
    }
}

