/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.http;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.PreDestroy;
import javax.net.ssl.HostnameVerifier;
import lombok.Generated;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultBackoffStrategy;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apereo.cas.util.http.SimpleHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class SimpleHttpClientFactoryBean
implements FactoryBean<SimpleHttpClient> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHttpClientFactoryBean.class);
    public static final int MAX_CONNECTIONS_PER_ROUTE = 50;
    private static final int MAX_POOLED_CONNECTIONS = 100;
    private static final int DEFAULT_THREADS_NUMBER = 200;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int[] DEFAULT_ACCEPTABLE_CODES = new int[]{200, 304, 302, 301, 202, 204};
    private static final int DEFAULT_QUEUE_SIZE = 40;
    private int threadsNumber = 200;
    private int queueSize = 40;
    private int maxPooledConnections = 100;
    private int maxConnectionsPerRoute = 50;
    private List<Integer> acceptableCodes = IntStream.of(DEFAULT_ACCEPTABLE_CODES).boxed().collect(Collectors.toList());
    private long connectionTimeout = 5000L;
    private int readTimeout = 5000;
    private RedirectStrategy redirectionStrategy = new DefaultRedirectStrategy();
    private SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
    private HostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
    private CredentialsProvider credentialsProvider;
    private CookieStore cookieStore;
    private ConnectionReuseStrategy connectionReuseStrategy = new DefaultConnectionReuseStrategy();
    private ConnectionBackoffStrategy connectionBackoffStrategy = new DefaultBackoffStrategy();
    private ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy = new DefaultServiceUnavailableRetryStrategy();
    private Collection<? extends Header> defaultHeaders = new ArrayList<Header>(0);
    private AuthenticationStrategy proxyAuthenticationStrategy = new ProxyAuthenticationStrategy();
    private boolean circularRedirectsAllowed = true;
    private boolean authenticationEnabled;
    private boolean redirectsEnabled = true;
    private ExecutorService executorService;

    public SimpleHttpClient getObject() {
        CloseableHttpClient httpClient = this.buildHttpClient();
        FutureRequestExecutionService requestExecutorService = this.buildRequestExecutorService(httpClient);
        List<Integer> codes = this.acceptableCodes.stream().sorted().collect(Collectors.toList());
        return new SimpleHttpClient(codes, httpClient, requestExecutorService);
    }

    public Class<?> getObjectType() {
        return SimpleHttpClient.class;
    }

    public boolean isSingleton() {
        return false;
    }

    private CloseableHttpClient buildHttpClient() {
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslsf = this.sslSocketFactory;
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager connMgmr = new PoolingHttpClientConnectionManager(registry);
        connMgmr.setMaxTotal(this.maxPooledConnections);
        connMgmr.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
        connMgmr.setValidateAfterInactivity(5000);
        HttpHost httpHost = new HttpHost(InetAddress.getLocalHost());
        HttpRoute httpRoute = new HttpRoute(httpHost);
        connMgmr.setMaxPerRoute(httpRoute, 50);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.readTimeout).setConnectTimeout((int)this.connectionTimeout).setConnectionRequestTimeout((int)this.connectionTimeout).setCircularRedirectsAllowed(this.circularRedirectsAllowed).setRedirectsEnabled(this.redirectsEnabled).setAuthenticationEnabled(this.authenticationEnabled).build();
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMgmr).setDefaultRequestConfig(requestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setSSLHostnameVerifier(this.hostnameVerifier).setRedirectStrategy(this.redirectionStrategy).setDefaultCredentialsProvider(this.credentialsProvider).setDefaultCookieStore(this.cookieStore).setConnectionReuseStrategy(this.connectionReuseStrategy).setConnectionBackoffStrategy(this.connectionBackoffStrategy).setServiceUnavailableRetryStrategy(this.serviceUnavailableRetryStrategy).setProxyAuthenticationStrategy(this.proxyAuthenticationStrategy).setDefaultHeaders(this.defaultHeaders).useSystemProperties();
        return builder.build();
    }

    private FutureRequestExecutionService buildRequestExecutorService(CloseableHttpClient httpClient) {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(this.threadsNumber, this.threadsNumber, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.queueSize));
        }
        return new FutureRequestExecutionService((HttpClient)httpClient, this.executorService);
    }

    @PreDestroy
    public void destroy() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    @Generated
    public void setThreadsNumber(int threadsNumber) {
        this.threadsNumber = threadsNumber;
    }

    @Generated
    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    @Generated
    public void setMaxPooledConnections(int maxPooledConnections) {
        this.maxPooledConnections = maxPooledConnections;
    }

    @Generated
    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    @Generated
    public void setAcceptableCodes(List<Integer> acceptableCodes) {
        this.acceptableCodes = acceptableCodes;
    }

    @Generated
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Generated
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Generated
    public void setRedirectionStrategy(RedirectStrategy redirectionStrategy) {
        this.redirectionStrategy = redirectionStrategy;
    }

    @Generated
    public void setSslSocketFactory(SSLConnectionSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    @Generated
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    @Generated
    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    @Generated
    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    @Generated
    public void setConnectionReuseStrategy(ConnectionReuseStrategy connectionReuseStrategy) {
        this.connectionReuseStrategy = connectionReuseStrategy;
    }

    @Generated
    public void setConnectionBackoffStrategy(ConnectionBackoffStrategy connectionBackoffStrategy) {
        this.connectionBackoffStrategy = connectionBackoffStrategy;
    }

    @Generated
    public void setServiceUnavailableRetryStrategy(ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        this.serviceUnavailableRetryStrategy = serviceUnavailableRetryStrategy;
    }

    @Generated
    public void setDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    @Generated
    public void setProxyAuthenticationStrategy(AuthenticationStrategy proxyAuthenticationStrategy) {
        this.proxyAuthenticationStrategy = proxyAuthenticationStrategy;
    }

    @Generated
    public void setCircularRedirectsAllowed(boolean circularRedirectsAllowed) {
        this.circularRedirectsAllowed = circularRedirectsAllowed;
    }

    @Generated
    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    @Generated
    public void setRedirectsEnabled(boolean redirectsEnabled) {
        this.redirectsEnabled = redirectsEnabled;
    }

    @Generated
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public static class DefaultHttpClient
    extends SimpleHttpClientFactoryBean {
    }
}

