/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.scripting;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.AccessController;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.ResourceUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public final class ScriptingUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptingUtils.class);
    private static final Pattern INLINE_GROOVY_PATTERN = RegexUtils.createPattern("groovy\\s*\\{\\s*(.+)\\s*\\}", 40);
    private static final Pattern FILE_GROOVY_PATTERN = RegexUtils.createPattern("(file|classpath):(.+\\.groovy)");

    public static boolean isInlineGroovyScript(String script) {
        return ScriptingUtils.getMatcherForInlineGroovyScript(script).find();
    }

    public static boolean isExternalGroovyScript(String script) {
        return ScriptingUtils.getMatcherForExternalGroovyScript(script).find();
    }

    public static Matcher getMatcherForInlineGroovyScript(String script) {
        return INLINE_GROOVY_PATTERN.matcher(script);
    }

    public static Matcher getMatcherForExternalGroovyScript(String script) {
        return FILE_GROOVY_PATTERN.matcher(script);
    }

    public static <T> T executeGroovyShellScript(String script, Map<String, Object> variables, Class<T> clazz) {
        try {
            Binding binding = new Binding();
            GroovyShell shell = new GroovyShell(binding);
            if (variables != null && !variables.isEmpty()) {
                variables.forEach((arg_0, arg_1) -> ((Binding)binding).setVariable(arg_0, arg_1));
            }
            if (!binding.hasVariable("logger")) {
                binding.setVariable("logger", (Object)LOGGER);
            }
            LOGGER.debug("Executing groovy script [{}] with variables [{}]", (Object)script, (Object)binding.getVariables());
            Object result = shell.evaluate(script);
            if (result != null && !clazz.isAssignableFrom(result.getClass())) {
                throw new ClassCastException("Result [" + result + " is of type " + result.getClass() + " when we were expecting " + clazz);
            }
            return (T)result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T executeGroovyScript(Resource groovyScript, Object[] args, Class<T> clazz) {
        return ScriptingUtils.executeGroovyScript(groovyScript, "run", args, clazz);
    }

    public static <T> T executeGroovyScript(Resource groovyScript, String methodName, Class<T> clazz, Object ... args) {
        return ScriptingUtils.executeGroovyScript(groovyScript, methodName, args, clazz);
    }

    public static <T> T executeGroovyScript(Resource groovyScript, String methodName, Class<T> clazz) {
        return ScriptingUtils.executeGroovyScript(groovyScript, methodName, new Object[0], clazz);
    }

    public static <T> T executeGroovyScript(Resource groovyScript, String methodName, Object[] args, Class<T> clazz) {
        if (groovyScript == null || StringUtils.isBlank((CharSequence)methodName)) {
            return null;
        }
        ClassLoader parent = ScriptingUtils.class.getClassLoader();
        return (T)AccessController.doPrivileged(() -> ScriptingUtils.getGroovyResult(groovyScript, methodName, args, clazz, parent));
    }

    public static <T> T executeGroovyScript(GroovyObject groovyObject, Object[] args, Class<T> clazz, boolean failOnError) {
        return ScriptingUtils.executeGroovyScript(groovyObject, "run", args, clazz, failOnError);
    }

    private static <T> T executeGroovyScript(GroovyObject groovyObject, String methodName, Object[] args, Class<T> clazz, boolean failOnError) {
        try {
            LOGGER.trace("Executing groovy script's [{}] method, with parameters [{}]", (Object)methodName, (Object)args);
            Object result = groovyObject.invokeMethod(methodName, (Object)args);
            LOGGER.trace("Results returned by the groovy script are [{}]", result);
            if (!clazz.equals(Void.class)) {
                if (result != null && !clazz.isAssignableFrom(result.getClass())) {
                    throw new ClassCastException("Result [" + result + " is of type " + result.getClass() + " when we were expecting " + clazz);
                }
                return (T)result;
            }
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvokerInvocationException ? e.getCause() : e;
            if (failOnError) {
                throw cause;
            }
            LOGGER.error(cause.getMessage(), cause);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T getGroovyResult(Resource groovyScript, String methodName, Object[] args, Class<T> clazz, ClassLoader parent) {
        try (GroovyClassLoader loader = new GroovyClassLoader(parent);){
            File groovyFile = groovyScript.getFile();
            if (groovyFile.exists()) {
                Class groovyClass = loader.parseClass(groovyFile);
                LOGGER.trace("Creating groovy object instance from class [{}]", (Object)groovyFile.getCanonicalPath());
                GroovyObject groovyObject = (GroovyObject)groovyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LOGGER.trace("Executing groovy script's [{}] method, with parameters [{}]", (Object)methodName, (Object)args);
                Object result = groovyObject.invokeMethod(methodName, (Object)args);
                LOGGER.trace("Results returned by the groovy script are [{}]", result);
                if (result != null && !clazz.isAssignableFrom(result.getClass())) {
                    throw new ClassCastException("Result [" + result + " is of type " + result.getClass() + " when we were expecting " + clazz);
                }
                Object object = result;
                return (T)object;
            }
            LOGGER.trace("Groovy script at [{}] does not exist", (Object)groovyScript);
            return null;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static <T> T executeScriptEngine(String scriptFile, Object[] args, Class<T> clazz) {
        try {
            String engineName = ScriptingUtils.getScriptEngineName(scriptFile);
            ScriptEngine engine = new ScriptEngineManager().getEngineByName(engineName);
            if (engine == null || StringUtils.isBlank((CharSequence)engineName)) {
                LOGGER.warn("Script engine is not available for [{}]", (Object)engineName);
                return null;
            }
            AbstractResource resourceFrom = ResourceUtils.getResourceFrom(scriptFile);
            File theScriptFile = resourceFrom.getFile();
            if (theScriptFile.exists()) {
                LOGGER.debug("Created object instance from class [{}]", (Object)theScriptFile.getCanonicalPath());
                engine.eval(Files.newBufferedReader(theScriptFile.toPath(), StandardCharsets.UTF_8));
                Invocable invocable = (Invocable)((Object)engine);
                LOGGER.debug("Executing script's run method, with parameters [{}]", args);
                Object result = invocable.invokeFunction("run", args);
                LOGGER.debug("Groovy script result is [{}]", result);
                if (result != null && !clazz.isAssignableFrom(result.getClass())) {
                    throw new ClassCastException("Result [" + result + " is of type " + result.getClass() + " when we were expecting " + clazz);
                }
                return (T)result;
            }
            LOGGER.warn("[{}] script [{}] does not exist, or cannot be loaded", (Object)StringUtils.capitalize((String)engineName), (Object)scriptFile);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static <T> T executeGroovyScriptEngine(String script, Map<String, Object> variables, Class<T> clazz) {
        try {
            Object result;
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("groovy");
            if (engine == null) {
                LOGGER.warn("Script engine is not available for Groovy");
                return null;
            }
            SimpleBindings binding = new SimpleBindings();
            if (variables != null && !variables.isEmpty()) {
                binding.putAll((Map<? extends String, ? extends Object>)variables);
            }
            if (!binding.containsKey("logger")) {
                binding.put("logger", (Object)LOGGER);
            }
            if ((result = engine.eval(script, (Bindings)binding)) != null && !clazz.isAssignableFrom(result.getClass())) {
                throw new ClassCastException("Result [" + result + " is of type " + result.getClass() + " when we were expecting " + clazz);
            }
            return (T)result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T getObjectInstanceFromGroovyResource(Resource resource, Class<T> expectedType) {
        return ScriptingUtils.getObjectInstanceFromGroovyResource(resource, new Class[0], new Object[0], expectedType);
    }

    public static <T> T getObjectInstanceFromGroovyResource(Resource resource, Class[] constructorArgs, Object[] args, Class<T> expectedType) {
        try {
            if (resource == null) {
                LOGGER.debug("No groovy script is defined");
                return null;
            }
            String script = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            Class clazz = AccessController.doPrivileged(() -> {
                GroovyClassLoader classLoader = new GroovyClassLoader(ScriptingUtils.class.getClassLoader(), new CompilerConfiguration(), true);
                return classLoader.parseClass(script);
            });
            LOGGER.debug("Preparing constructor arguments [{}] for resource [{}]", (Object)args, (Object)resource);
            Constructor ctor = clazz.getDeclaredConstructor(constructorArgs);
            Object result = ctor.newInstance(args);
            if (result != null && !expectedType.isAssignableFrom(result.getClass())) {
                throw new ClassCastException("Result [" + result + " is of type " + result.getClass() + " when we were expecting " + expectedType);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static GroovyObject parseGroovyScript(Resource groovyScript, boolean failOnError) {
        return AccessController.doPrivileged(() -> {
            ClassLoader parent = ScriptingUtils.class.getClassLoader();
            try {
                GroovyClassLoader loader = new GroovyClassLoader(parent);
                Throwable throwable = null;
                try {
                    File groovyFile = groovyScript.getFile();
                    if (groovyFile.exists()) {
                        Class groovyClass = loader.parseClass(groovyFile);
                        LOGGER.trace("Creating groovy object instance from class [{}]", (Object)groovyFile.getCanonicalPath());
                        GroovyObject groovyObject = (GroovyObject)groovyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        return groovyObject;
                    }
                    LOGGER.trace("Groovy script at [{}] does not exist", (Object)groovyScript);
                    return null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    ScriptingUtils.$closeResource(throwable, (AutoCloseable)loader);
                }
            }
            catch (Exception e) {
                if (failOnError) {
                    throw new RuntimeException(e);
                }
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return null;
        });
    }

    private static String getScriptEngineName(String scriptFile) {
        String engineName = null;
        if (scriptFile.endsWith(".py")) {
            engineName = "python";
        } else if (scriptFile.endsWith(".js")) {
            engineName = "js";
        } else if (scriptFile.endsWith(".groovy")) {
            engineName = "groovy";
        }
        return engineName;
    }

    @Generated
    private ScriptingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

